/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.item;

import com.mojang.logging.LogUtils;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.vit.jurassicreborn.common.entities.ModEntities;
import net.vit.jurassicreborn.common.items.ModItems;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AttractionSignEntity
extends HangingEntity
implements IEntityAdditionalSpawnData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Predicate<Entity> IS_OTHER_SIGN = e -> e instanceof AttractionSignEntity;
    private AttractionSignType type;

    public AttractionSignEntity(EntityType<? extends AttractionSignEntity> entityType, Level world) {
        super(entityType, world);
        this.type = AttractionSignType.AQUARIUM;
        this.f_19811_ = true;
    }

    public AttractionSignEntity(Level world, BlockPos pos, Direction facing, AttractionSignType type) {
        super((EntityType)ModEntities.ATTRACTION_SIGN.get(), world, pos);
        this.type = type;
        this.m_6022_(facing);
        this.f_19811_ = true;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("SignType", this.type.ordinal());
        tag.m_128344_("Facing", (byte)this.f_31699_.m_122416_());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        int idx = Mth.m_14045_((int)tag.m_128451_("SignType"), (int)0, (int)(AttractionSignType.values().length - 1));
        this.type = AttractionSignType.values()[idx];
        if (tag.m_128441_("Facing")) {
            this.m_6022_(Direction.m_122407_((int)tag.m_128445_("Facing")));
        }
    }

    public void writeSpawnData(FriendlyByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeLong(this.m_31748_().m_121878_());
        buf.writeByte(this.f_31699_.m_122416_());
    }

    public void readSpawnData(FriendlyByteBuf buf) {
        BlockPos p;
        int idx = Mth.m_14045_((int)buf.readInt(), (int)0, (int)(AttractionSignType.values().length - 1));
        this.type = AttractionSignType.values()[idx];
        this.f_31698_ = p = BlockPos.m_122022_((long)buf.readLong());
        this.m_6022_(Direction.m_122407_((int)buf.readUnsignedByte()));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int m_7076_() {
        return 16;
    }

    public int m_7068_() {
        return 16;
    }

    public void m_5553_(@Nullable Entity broke) {
        block2: {
            block3: {
                if (this.m_9236_().m_5776_() || !this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) break block2;
                if (!(broke instanceof Player)) break block3;
                Player p = (Player)broke;
                if (p.m_150110_().f_35937_) break block2;
            }
            ItemStack stack = new ItemStack((ItemLike)ModItems.ATTRACTION_SIGNS.get((Object)this.type).get());
            this.m_5552_(stack, 0.0f);
        }
    }

    public void m_7084_() {
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ModItems.ATTRACTION_SIGNS.get((Object)this.type).get());
    }

    public boolean m_7088_() {
        if (!this.m_9236_().m_45786_((Entity)this)) {
            return false;
        }
        return this.m_9236_().m_6443_(AttractionSignEntity.class, this.m_20191_(), e -> e != this).isEmpty();
    }

    protected void m_7087_() {
        super.m_7087_();
    }

    public ResourceLocation getFaceTexture() {
        return this.type.textureFace;
    }

    public ResourceLocation getPopoutTexture() {
        return this.type.texturePopout;
    }

    public static enum AttractionSignType {
        AQUARIUM,
        AQUARIUM_CORAL,
        AVIARY,
        AVIARY_PLANTS,
        GALLIMIMUS_VALLEY,
        GALLIMIMUS_VALLEY_PLANTS,
        GENTLE_GIANTS,
        GENTLE_GIANTS_PLANTS,
        RAPTOR_PADDOCK,
        RAPTOR_PADDOCK_PLANTS,
        SAFARI,
        SAFARI_PLANTS,
        TRICERATOPS_TERRITORIUM,
        TRICERATOPS_TERRITORIUM_PLANTS,
        GARDEN,
        GARDEN_PLANTS,
        TYRANNOSAURUS_KINGDOM,
        TYRANNOSAURUS_KINGDOM_PLANTS,
        CENOZOIC_PARK,
        CENOZOIC_PARK_PLANTS,
        SMILODON_COVE,
        SMILODON_COVE_PLANTS,
        CARNIVORE_PADDOCK,
        CARNIVORE_PADDOCK_PLANTS,
        HERBIVORE_PADDOCK,
        HERBIVORE_PADDOCK_PLANTS,
        HYAENODON_LAIR,
        HYAENODON_LAIR_PLANTS,
        HYBRID_PADDOCK,
        HYBRID_PADDOCK_PLANTS,
        HYBRID_HILLS,
        HYBRID_HILLS_PLANTS,
        MAMMOTH_PLAINS,
        MAMMOTH_PLAINS_PLANTS,
        PREHISTORIC_LAKE,
        PREHISTORIC_LAKE_PLANTS,
        MOSA_FEEDING,
        TYLO_FEEDING,
        VISITOR_CENTER,
        VISITOR_CENTER_PLANTS,
        SPINO_SWAMP,
        SPINO_SWAMP_PLANTS,
        SAUROPOD_VALLEY,
        SAUROPOD_VALLEY_PLANTS,
        LOGO,
        LOGO_PLANTS,
        GIFT_SHOP,
        GIFT_SHOP_PLANTS,
        RESTAURANT,
        RESTAURANT_PLANTS,
        LABORATORY,
        LABORATORY_PLANTS,
        COELACANTH_POND,
        COELACANTH_POND_CORAL,
        PREHISTORIC_RIVER,
        PREHISTORIC_RIVER_PLANTS,
        GYROSPHERE_STATION,
        GYROSPHERE_STATION_PLANTS,
        MONORAIL_STATION,
        MONORAIL_STATION_PLANTS,
        MUSEUM,
        MUSEUM_PLANTS,
        SAFARI_TOUR,
        SAFARI_TOUR_PLANTS,
        INDORAPTOR,
        INDORAPTOR_VARIANT,
        INDOMINUS_REX,
        INDOMINUS_REX_VARIANT,
        GARDEN_ALT,
        GARDEN_ALT_PLANTS;

        public final int sizeX;
        public final int sizeY;
        public final ResourceLocation textureFace;
        public final ResourceLocation texturePopout;

        private AttractionSignType() {
            this(128, 128);
        }

        private AttractionSignType(int sx, int sy) {
            this.sizeX = sx;
            this.sizeY = sy;
            String base = this.name().toLowerCase(Locale.ROOT);
            this.textureFace = new ResourceLocation("jurassicreborn", "textures/attraction_sign/" + base + ".png");
            this.texturePopout = new ResourceLocation("jurassicreborn", "textures/attraction_sign/" + base + "_popout.png");
        }
    }
}

