/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.item;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.vit.jurassicreborn.common.entities.ModEntities;
import net.vit.jurassicreborn.common.items.guns.Bullet;

public class BulletEntity
extends AbstractArrow
implements IEntityAdditionalSpawnData {
    private ItemStack ammoStack = ItemStack.f_41583_;
    private int damage = 5;

    public BulletEntity(EntityType<? extends BulletEntity> type, Level world) {
        super(type, world);
        this.m_20011_(this.m_20191_().m_82400_(0.1));
    }

    public BulletEntity(Level world, LivingEntity shooter, ItemStack ammo) {
        super((EntityType)ModEntities.BULLET_ENTITY.get(), shooter, world);
        this.ammoStack = ammo.m_41777_();
    }

    public void setDamage(int dmg) {
        this.damage = dmg;
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        if (!this.m_9236_().f_46443_) {
            Entity entity = result.m_82443_();
            if (entity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                if (this.ammoStack.m_41720_() instanceof Bullet) {
                    DamageSource src = this.m_269291_().m_269418_((AbstractArrow)this, this.m_19749_());
                    target.m_6469_(src, (float)this.damage);
                }
            }
            this.m_146870_();
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_) {
            this.m_146870_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (!this.m_9236_().f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.ammoStack);
        buffer.writeInt(this.damage);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.ammoStack = additionalData.m_130267_();
        this.damage = additionalData.readInt();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

