/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="jurassicreborn", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TabHandler {
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"jurassicreborn");
    private static final Map<String, Long> SCROLLING_TAB_UPDATE_TIME = new LinkedHashMap<String, Long>();
    private static final Map<String, Integer> SCROLLING_TAB_ICON_INDEX = new LinkedHashMap<String, Integer>();
    private static final Map<String, List<Supplier<ItemStack>>> SCROLLING_TAB_ICON_SUPPLIERS = new LinkedHashMap<String, List<Supplier<ItemStack>>>();
    private static final Map<ResourceLocation, List<Supplier<ItemStack>>> TAB_ITEM_SUPPLIERS = new LinkedHashMap<ResourceLocation, List<Supplier<ItemStack>>>();
    private static final Map<ResourceLocation, Supplier<ItemStack>> TAB_ICON_SUPPLIERS = new LinkedHashMap<ResourceLocation, Supplier<ItemStack>>();
    public static final RegistryObject<CreativeModeTab> ITEMS = TabHandler.registerTab("items", TabHandler.rotatingIcons("amber_mosquito", "amber_aphid", "dna_base_material"));
    public static final RegistryObject<CreativeModeTab> BLOCKS = TabHandler.registerTab("blocks", TabHandler.stackSupplier("gypsum_bricks"));
    public static final RegistryObject<CreativeModeTab> DECORATIONS = TabHandler.registerTab("decorations", TabHandler.stackSupplier("blueprint"));
    public static final RegistryObject<CreativeModeTab> DNA = TabHandler.registerTab("dna", TabHandler.stackSupplier("dna_base_material"));
    public static final RegistryObject<CreativeModeTab> SPAWN_EGGS = TabHandler.registerTab("spawn_eggs", () -> {
        ItemStack velociraptor = TabHandler.stackSupplier("spawn_egg/velociraptor_spawn_egg").get();
        return velociraptor.m_41619_() ? TabHandler.stackSupplier("goat_spawn_egg").get() : velociraptor;
    });
    public static final RegistryObject<CreativeModeTab> FOSSILS = TabHandler.registerTab("fossils", TabHandler.stackSupplier("fauna_fossil_block_item"));
    public static final RegistryObject<CreativeModeTab> FOODS = TabHandler.registerTab("foods", TabHandler.rotatingIcons("cooked_shark_meat", "raw_shark_meat", "fun_fries"));
    public static final RegistryObject<CreativeModeTab> PLANTS = TabHandler.registerTab("plants", TabHandler.stackSupplier("plant_callus"));

    private static RegistryObject<CreativeModeTab> registerTab(String name, Supplier<ItemStack> iconSupplier) {
        ResourceLocation id = new ResourceLocation("jurassicreborn", name);
        TAB_ICON_SUPPLIERS.put(id, iconSupplier);
        return TABS.register(name, () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)("itemGroup.jurassicreborn." + name))).m_257737_(iconSupplier).m_257501_((parameters, output) -> TAB_ITEM_SUPPLIERS.getOrDefault(id, List.of()).forEach(supplier -> output.m_246342_((ItemStack)supplier.get()))).m_257652_());
    }

    private static RegistryObject<CreativeModeTab> registerTab(String name, List<Supplier<ItemStack>> iconSuppliers) {
        return TabHandler.registerTab(name, TabHandler.createIconSupplier(name, iconSuppliers));
    }

    private static Supplier<ItemStack> createIconSupplier(String name, List<Supplier<ItemStack>> iconSuppliers) {
        if (iconSuppliers == null || iconSuppliers.isEmpty()) {
            return () -> ItemStack.f_41583_;
        }
        List<Supplier> sanitized = iconSuppliers.stream().filter(Objects::nonNull).map(TabHandler::sanitize).toList();
        if (sanitized.isEmpty()) {
            return () -> ItemStack.f_41583_;
        }
        if (sanitized.size() == 1) {
            return sanitized.get(0);
        }
        SCROLLING_TAB_ICON_SUPPLIERS.put(name, sanitized);
        return () -> {
            Supplier<ItemStack> current;
            List<Supplier<ItemStack>> suppliers = SCROLLING_TAB_ICON_SUPPLIERS.get(name);
            if (suppliers == null || suppliers.isEmpty()) {
                return ItemStack.f_41583_;
            }
            long now = System.currentTimeMillis();
            long last = SCROLLING_TAB_UPDATE_TIME.getOrDefault(name, 0L);
            int index = SCROLLING_TAB_ICON_INDEX.getOrDefault(name, 0);
            if (now - last >= 5000L) {
                index = (index + 1) % suppliers.size();
                SCROLLING_TAB_ICON_INDEX.put(name, index);
                SCROLLING_TAB_UPDATE_TIME.put(name, now);
            }
            return (current = suppliers.get(index)) != null ? current.get() : ItemStack.f_41583_;
        };
    }

    @SubscribeEvent
    public static void onBuildContents(BuildCreativeModeTabContentsEvent event) {
        ResourceLocation tabId = BuiltInRegistries.f_279662_.m_7981_((Object)event.getTab());
        if (tabId != null && TAB_ITEM_SUPPLIERS.containsKey(tabId)) {
            for (Supplier<ItemStack> stack : TAB_ITEM_SUPPLIERS.get(tabId)) {
                event.m_246342_(stack.get());
            }
        }
    }

    public static void addToTab(ResourceLocation tabId, Supplier<ItemStack> stackSupplier) {
        TAB_ITEM_SUPPLIERS.computeIfAbsent(tabId, k -> new ArrayList()).add(stackSupplier);
    }

    public static void addToTab(ResourceLocation tabId, RegistryObject<? extends Item> itemSupplier) {
        TabHandler.addToTab(tabId, () -> ((Item)itemSupplier.get()).m_7968_());
    }

    public static void addItemToTab(ResourceLocation tabId, Supplier<? extends Item> itemSupplier) {
        TabHandler.addToTab(tabId, () -> new ItemStack((ItemLike)itemSupplier.get()));
    }

    private static Supplier<ItemStack> sanitize(Supplier<ItemStack> supplier) {
        return () -> supplier == null ? ItemStack.f_41583_ : Optional.ofNullable((ItemStack)supplier.get()).orElse(ItemStack.f_41583_);
    }

    private static Supplier<ItemStack> stackSupplier(String path) {
        return () -> TabHandler.stackFromRegistry(path);
    }

    private static List<Supplier<ItemStack>> rotatingIcons(String ... itemIds) {
        ArrayList<Supplier<ItemStack>> suppliers = new ArrayList<Supplier<ItemStack>>();
        for (String id : itemIds) {
            suppliers.add(TabHandler.stackSupplier(id));
        }
        return suppliers;
    }

    private static ItemStack stackFromRegistry(String path) {
        ResourceLocation id;
        if (path == null || path.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ResourceLocation resourceLocation = id = path.contains(":") ? ResourceLocation.m_135820_((String)path) : new ResourceLocation("jurassicreborn", path);
        if (id == null) {
            return ItemStack.f_41583_;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
        if (item == null) {
            return ItemStack.f_41583_;
        }
        return item.m_7968_();
    }
}

