/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.vit.jurassicreborn.common.entities.vehicle.FordExplorerEntity;

public class FordExplorerChangeStateMessage {
    private final int entityId;
    private final boolean onRails;

    public FordExplorerChangeStateMessage(int entityId, boolean onRails) {
        this.entityId = entityId;
        this.onRails = onRails;
    }

    public static void encode(FordExplorerChangeStateMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.writeBoolean(msg.onRails);
    }

    public static FordExplorerChangeStateMessage decode(FriendlyByteBuf buf) {
        return new FordExplorerChangeStateMessage(buf.readInt(), buf.readBoolean());
    }

    public static void handle(FordExplorerChangeStateMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level level;
            Level level2 = level = ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient() ? (Level)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> Client::getLevel) : ((NetworkEvent.Context)ctx.get()).getSender().m_9236_();
            if (level == null) {
                return;
            }
            Entity e = level.m_6815_(msg.entityId);
            if (e instanceof FordExplorerEntity) {
                FordExplorerEntity car = (FordExplorerEntity)e;
                car.setOnRails(msg.onRails);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class Client {
        private Client() {
        }

        static Level getLevel() {
            return Minecraft.m_91087_().f_91073_;
        }
    }
}

