/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkEvent;
import net.vit.jurassicreborn.common.blocks.entities.HologramBlockEntity;

public class SetHologramDinosaurPacket {
    private final BlockPos pos;
    private final int dinosaurId;
    private final int poseIndex;
    private final boolean rotating;
    private final int rotation;

    public SetHologramDinosaurPacket(BlockPos pos, int dinosaurId, int poseIndex, boolean rotating, int rotation) {
        this.pos = pos;
        this.dinosaurId = dinosaurId;
        this.poseIndex = poseIndex;
        this.rotating = rotating;
        this.rotation = rotation;
    }

    public static void encode(SetHologramDinosaurPacket pkt, FriendlyByteBuf buf) {
        buf.m_130064_(pkt.pos);
        buf.writeInt(pkt.dinosaurId);
        buf.writeInt(pkt.poseIndex);
        buf.writeBoolean(pkt.rotating);
        buf.writeInt(pkt.rotation);
    }

    public static SetHologramDinosaurPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        int id = buf.readInt();
        int pose = buf.readInt();
        boolean rotating = buf.readBoolean();
        int rotation = buf.readInt();
        return new SetHologramDinosaurPacket(pos, id, pose, rotating, rotation);
    }

    public static void handle(SetHologramDinosaurPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Level level = player.m_9236_();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            BlockEntity be = level.m_7702_(pkt.pos);
            if (!(be instanceof HologramBlockEntity)) {
                return;
            }
            HologramBlockEntity hologram = (HologramBlockEntity)be;
            hologram.applySettings(pkt.dinosaurId, pkt.poseIndex, pkt.rotating, pkt.rotation, true);
            hologram.m_6596_();
            serverLevel.m_7260_(pkt.pos, hologram.m_58900_(), hologram.m_58900_(), 3);
            serverLevel.m_7726_().m_8450_(pkt.pos);
            try {
                LevelChunk chunk = serverLevel.m_46745_(pkt.pos);
                chunk.m_8092_(true);
                CompoundTag tag = new CompoundTag();
                hologram.m_183515_(tag);
                hologram.m_187476_(ItemStack.m_41712_((CompoundTag)tag));
                hologram.m_187480_();
                chunk.m_6344_();
                serverLevel.m_7726_().m_8483_().m_78151_();
            }
            catch (Exception e) {
                System.err.println("[JurassicReborn] Failed to save HologramBlockEntity at " + pkt.pos + ": " + e);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

