/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.vit.jurassicreborn.common.util.block.TemperatureControl;

public class SetIncubatorTempServerboundPacket {
    private BlockPos pos;
    private int slotIndex;
    private int temp;
    private ResourceKey<Level> dimension;

    public SetIncubatorTempServerboundPacket(BlockPos pos, int slotIndex, int temperature, ResourceKey<Level> dim) {
        this.pos = pos;
        this.slotIndex = slotIndex;
        this.temp = temperature;
        this.dimension = dim;
    }

    public static void handle(SetIncubatorTempServerboundPacket packet, Supplier<NetworkEvent.Context> ctx) {
        if (Thread.currentThread() != ctx.get().getSender().m_20194_().m_6304_()) {
            SetIncubatorTempServerboundPacket.handleOnRenderThread(packet, ctx);
        }
    }

    public static void handleOnRenderThread(SetIncubatorTempServerboundPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        ServerLevel dim = player.m_284548_();
        if (dim.f_46443_) {
            return;
        }
        BlockEntity e = dim.m_7702_(packet.pos);
        if (e == null) {
            e = dim.m_46745_(packet.pos).m_7702_(packet.pos);
        }
        if (e instanceof TemperatureControl) {
            TemperatureControl temperatureControl = (TemperatureControl)e;
            if (dim.m_46472_().equals(packet.dimension) && packet.slotIndex < temperatureControl.getTemperatureCount()) {
                temperatureControl.setTemperature(packet.slotIndex, packet.temp);
            }
        }
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeInt(this.slotIndex);
        buffer.writeInt(this.temp);
        buffer.m_236858_(this.dimension);
    }

    public static SetIncubatorTempServerboundPacket read(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        int slotIndex = buffer.readInt();
        int temp = buffer.readInt();
        ResourceKey dim = buffer.m_236801_(Registries.f_256858_);
        return new SetIncubatorTempServerboundPacket(pos, slotIndex, temp, (ResourceKey<Level>)dim);
    }
}

