/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.vit.jurassicreborn.common.entities.vehicle.VehicleEntity;

public class UpdateVehicleControlMessage {
    private final int entityId;
    private final byte state;

    public UpdateVehicleControlMessage(int entityId, byte state) {
        this.entityId = entityId;
        this.state = state;
    }

    public static void encode(UpdateVehicleControlMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.writeByte((int)msg.state);
    }

    public static UpdateVehicleControlMessage decode(FriendlyByteBuf buf) {
        return new UpdateVehicleControlMessage(buf.readInt(), buf.readByte());
    }

    public static void handle(UpdateVehicleControlMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            VehicleEntity car;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Entity e = player.m_9236_().m_6815_(msg.entityId);
            if (e instanceof VehicleEntity && (car = (VehicleEntity)e).m_6688_() == player) {
                car.setControlState(msg.state);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

