/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.plants;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.FakePlayer;
import net.vit.jurassicreborn.common.items.ModItems;

public class WestIndianLilacBlock
extends DoublePlantBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)2);

    public WestIndianLilacBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50035_).m_60910_().m_60918_(SoundType.f_56740_));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.LOWER));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) >= 2;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AGE});
    }

    public boolean m_6724_(BlockState state) {
        return !this.isMaxAge(state);
    }

    public boolean m_7370_(LevelReader levelReader, BlockPos blockPos, BlockState blockState, boolean b) {
        return !this.isMaxAge(blockState);
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER) {
            BlockState downState = level.m_8055_(pos.m_7495_());
            Block block = downState.m_60734_();
            if (block instanceof BonemealableBlock) {
                BonemealableBlock growable = (BonemealableBlock)block;
                growable.m_214148_(level, random, pos.m_7495_(), downState);
            }
            return;
        }
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age < 2) {
            int newAge = Mth.m_14045_((int)(age + 1), (int)0, (int)2);
            BlockState newState = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge));
            level.m_7731_(pos, newState, 2);
            level.m_7731_(pos.m_7494_(), (BlockState)newState.m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.UPPER), 2);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.isMaxAge(state) && random.m_188503_(5) == 0) {
            this.m_214148_(level, random, pos, state);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        DoubleBlockHalf half;
        BlockPos otherPos;
        BlockState otherState;
        if (!state.m_60713_(newState.m_60734_()) && (otherState = level.m_8055_(otherPos = (half = (DoubleBlockHalf)state.m_61143_((Property)f_52858_)) == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_())).m_60713_((Block)this) && otherState.m_61143_((Property)f_52858_) != half) {
            level.m_7731_(otherPos, Blocks.f_50016_.m_49966_(), 35);
            level.m_46796_(2001, otherPos, Block.m_49956_((BlockState)otherState));
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER) {
            BlockState downState = level.m_8055_(pos.m_7495_());
            if (downState.m_60734_() instanceof WestIndianLilacBlock) {
                return downState.m_60734_().m_6227_(downState, level, pos.m_7495_(), player, hand, hit);
            }
            return InteractionResult.PASS;
        }
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age == 2) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            int newAge = Mth.m_14045_((int)(age - 1), (int)0, (int)2);
            BlockState newState = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge));
            level.m_7731_(pos, newState, 2);
            level.m_7731_(pos.m_7494_(), (BlockState)newState.m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.UPPER), 2);
            ItemStack itemDrop = new ItemStack((ItemLike)ModItems.WEST_INDIAN_LILAC_BERRIES.get());
            ItemEntity entityItem = new ItemEntity(level, player.m_20185_(), player.m_20186_() - 1.0, player.m_20189_(), itemDrop);
            level.m_7967_((Entity)entityItem);
            if (!(player instanceof FakePlayer)) {
                entityItem.m_6123_(player);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

