/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.util.networking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.text.html.parser.Entity;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.vit.jurassicreborn.common.paleopad.App;
import net.vit.jurassicreborn.common.paleopad.AppHandler;

public class PlayerData {
    public static final String IDENTIFIER = "jurassicreborn:playerdata";
    private final Map<String, CompoundTag> appdata = new HashMap<String, CompoundTag>();
    private final List<App> openApps = new ArrayList<App>();
    public static final Capability<PlayerData> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerData>(){});

    public void saveNBTData(CompoundTag nbt) {
        ListTag appDataList = new ListTag();
        for (Map.Entry<String, CompoundTag> data : this.appdata.entrySet()) {
            CompoundTag appData = new CompoundTag();
            appData.m_128359_("Name", data.getKey());
            appData.m_128365_("Data", (Tag)data.getValue().m_6426_());
            appDataList.add((Object)appData);
        }
        nbt.m_128365_("RBAppData", (Tag)appDataList);
    }

    public void loadNBTData(CompoundTag nbt) {
        this.appdata.clear();
        ListTag appDataList = nbt.m_128437_("RBAppData", 10);
        block0: for (int i = 0; i < appDataList.size(); ++i) {
            CompoundTag appData = appDataList.m_128728_(i);
            String name = appData.m_128461_("Name");
            CompoundTag data = appData.m_128469_("Data");
            this.appdata.put(name, data);
            for (App app : AppHandler.INSTANCE.getApps()) {
                if (!app.getName().equals(name)) continue;
                app.readAppFromNBT(data);
                continue block0;
            }
        }
    }

    public List<App> getOpenApps() {
        return this.openApps;
    }

    public Map<String, CompoundTag> getAppdata() {
        return this.appdata;
    }

    public void openApp(App app) {
        if (this.appdata.containsKey(app.getName())) {
            app.readAppFromNBT(this.appdata.get(app.getName()));
        }
        app.init();
        app.open();
        if (!this.openApps.contains(app)) {
            this.openApps.add(app);
        }
    }

    public void closeApp(App app) {
        CompoundTag data = new CompoundTag();
        app.writeAppToNBT(data);
        this.appdata.put(app.getName(), data);
        this.openApps.remove(app);
    }

    public static void attach(Player player, AttachCapabilitiesEvent<Entity> event) {
        if (player instanceof Player) {
            event.addCapability(new ResourceLocation("jurassicreborn", "playerdata"), (ICapabilityProvider)new PlayerDataProvider());
        }
    }

    public static PlayerData get(Player player) {
        return (PlayerData)player.getCapability(CAPABILITY).orElseThrow(() -> new IllegalStateException("No PlayerData capability attached!"));
    }

    public static class PlayerDataProvider
    implements ICapabilitySerializable<CompoundTag> {
        private final PlayerData instance = new PlayerData();
        private final LazyOptional<PlayerData> optional = LazyOptional.of(() -> this.instance);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return cap == CAPABILITY ? this.optional.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            this.instance.saveNBTData(tag);
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.instance.loadNBTData(nbt);
        }
    }
}

