/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen.tree;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.vit.jurassicreborn.common.blocks.wood.AncientLeavesBlock;
import net.vit.jurassicreborn.common.blocks.wood.WoodBlocks;
import net.vit.jurassicreborn.common.worldgen.tree.TreePlaceUtil;

public class AraucariaTreeGenerator
extends Feature<NoneFeatureConfiguration> {
    public AraucariaTreeGenerator(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        int branchHeight;
        WorldGenLevel world = pContext.m_159774_();
        BlockState log = ((RotatedPillarBlock)WoodBlocks.ARAUCARIA_LOG.get()).m_49966_();
        BlockState leaves = (BlockState)((Block)WoodBlocks.ARAUCARIA_LEAVES.get()).m_49966_().m_61124_((Property)AncientLeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1));
        BlockPos position = pContext.m_159777_();
        RandomSource rand = pContext.m_225041_();
        int height = rand.m_188503_(15) + 10;
        if (!this.canPlace(pContext, height, branchHeight = (int)((double)height / 1.3))) {
            return false;
        }
        world.m_7731_(position, log, 19);
        for (int y = 0; y < height; ++y) {
            BlockPos logPos = position.m_6630_(y);
            world.m_7731_(logPos, log, 19);
            if (y <= branchHeight) continue;
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                Direction.Axis axis = facing.m_122434_();
                boolean zAxis = axis == Direction.Axis.Z;
                if (y % 2 != (facing.m_122421_() == Direction.AxisDirection.POSITIVE ? 0 : 1)) continue;
                BlockPos branch = logPos.m_121955_(facing.m_122436_());
                BlockState facingLog = (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)(zAxis ? Direction.Axis.Z : Direction.Axis.X));
                world.m_7731_(branch, facingLog, 19);
                this.generateClump(world, branch, 1.2, leaves);
                if (!((double)y > (double)branchHeight * 1.2)) continue;
                world.m_7731_(branch.m_7494_().m_121955_(facing.m_122436_()), facingLog, 19);
                this.generateClump(world, branch.m_7494_().m_121955_(facing.m_122436_()), 4.0, leaves);
            }
        }
        if (rand.m_188503_(10) == 0) {
            this.generateClump(world, position.m_6630_(height), 64.0, 6.0, leaves);
            this.generateClump(world, position.m_6630_(height), 8.0, 8.0, leaves);
        } else {
            this.generateClump(world, position.m_6630_(height), 32.0, 6.0, leaves);
            this.generateClump(world, position.m_6630_(height), 6.0, 6.0, leaves);
        }
        this.generateClump(world, position.m_6630_(height + 2), 16.0, 3.5, leaves);
        return true;
    }

    private boolean canPlace(FeaturePlaceContext<NoneFeatureConfiguration> pContext, int height, int branchHeight) {
        BlockPos.MutableBlockPos min = pContext.m_159777_().m_122032_();
        min.m_122184_(-6, branchHeight, -6);
        BlockPos.MutableBlockPos max = pContext.m_159777_().m_122032_();
        max.m_122184_(6, height + 4, 6);
        for (int y = 0; y < branchHeight; ++y) {
            if (TreePlaceUtil.validTreePos(pContext.m_159774_(), pContext.m_159777_().m_6630_(y))) continue;
            return false;
        }
        for (int x = min.m_123341_(); x < max.m_123341_(); ++x) {
            for (int y = min.m_123342_(); y < max.m_123342_(); ++y) {
                for (int z = min.m_123343_(); z < max.m_123343_(); ++z) {
                    if (TreePlaceUtil.validTreePos(pContext.m_159774_(), new BlockPos(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void generateClump(WorldGenLevel world, BlockPos pos, double size, BlockState state) {
        int blockRadius = (int)Math.ceil(size);
        for (int x = -blockRadius; x < blockRadius; ++x) {
            for (int y = -blockRadius; y < blockRadius; ++y) {
                for (int z = -blockRadius; z < blockRadius; ++z) {
                    BlockPos leafPos;
                    if (!((double)Math.abs(x * x + y * y + z * z) <= size) || world.m_8055_(leafPos = pos.m_7918_(x, y, z)) != Blocks.f_50016_.m_49966_()) continue;
                    this.setBlockState(world, leafPos, state);
                }
            }
        }
    }

    private void generateClump(WorldGenLevel world, BlockPos pos, double size, double sizeY, BlockState state) {
        int blockRadius = (int)Math.ceil(size);
        for (int x = -blockRadius; x < blockRadius; ++x) {
            for (int y = -blockRadius; y < blockRadius; ++y) {
                for (int z = -blockRadius; z < blockRadius; ++z) {
                    BlockPos leafPos;
                    if (!(Math.abs((double)(x * x) + (double)(y * y) * (size / sizeY) + (double)(z * z)) <= size) || !world.m_8055_(leafPos = pos.m_7918_(x, y, z)).m_60795_()) continue;
                    this.setBlockState(world, leafPos, state);
                }
            }
        }
    }

    private void setBlockState(WorldGenLevel world, BlockPos pos, BlockState state) {
        Block block = world.m_8055_(pos).m_60734_();
        if (AraucariaTreeGenerator.isReplaceablePlant(world, pos) || block instanceof LeavesBlock || block instanceof SaplingBlock || block instanceof RotatedPillarBlock || block == Blocks.f_50016_) {
            world.m_7731_(pos, state, 19);
        }
    }

    static boolean isReplaceablePlant(WorldGenLevel p_67289_, BlockPos p_67290_) {
        return p_67289_.m_7433_(p_67290_, state -> state.m_204336_(BlockTags.f_278394_));
    }
}

