/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen.tree;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.vit.jurassicreborn.common.blocks.wood.AncientLeavesBlock;
import net.vit.jurassicreborn.common.blocks.wood.WoodBlocks;
import net.vit.jurassicreborn.common.worldgen.tree.TreePlaceUtil;

public class BaseTreeGenerator
extends Feature<NoneFeatureConfiguration> {
    private final Supplier<BlockState> trunk;
    private final Supplier<BlockState> leaves;

    public BaseTreeGenerator(Codec<NoneFeatureConfiguration> pCodec, Supplier<BlockState> trunk, Supplier<BlockState> leaves) {
        super(pCodec);
        this.trunk = trunk;
        this.leaves = leaves;
    }

    public static BaseTreeGenerator ginkgo(Codec<NoneFeatureConfiguration> pCodec) {
        return new BaseTreeGenerator(pCodec, () -> ((RotatedPillarBlock)WoodBlocks.GINKGO_LOG.get()).m_49966_(), () -> (BlockState)((Block)WoodBlocks.GINKGO_LEAVES.get()).m_49966_().m_61124_((Property)AncientLeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)));
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockState log = this.trunk.get();
        BlockState leaves = this.leaves.get();
        RandomSource rand = context.m_225041_();
        BlockPos position = context.m_159777_();
        WorldGenLevel world = context.m_159774_();
        int height = rand.m_188503_(16) + 4;
        if (!this.canPlace(context, height)) {
            return false;
        }
        world.m_7731_(position, log, 19);
        for (int y = 0; y < height; ++y) {
            BlockPos logPos = position.m_6630_(y);
            BaseTreeGenerator.setBlockState(world, logPos, log);
            int branchLength = Math.max(1, (height - y) / 3);
            if (y >= 2) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && z == 0) continue;
                        BaseTreeGenerator.setBlockState(world, logPos.m_7918_(x, 0, z), leaves);
                    }
                }
                int bushSize = (int)((double)branchLength * 1.8);
                for (int x = -bushSize; x <= bushSize; ++x) {
                    for (int z = -bushSize; z <= bushSize; ++z) {
                        if (x == 0 && z == 0 || !(Math.sqrt(x * x + z * z) < (double)bushSize)) continue;
                        BaseTreeGenerator.setBlockState(world, logPos.m_7918_(x, 0, z), leaves);
                    }
                }
            }
            if (y % 3 != 2) continue;
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                BlockPos branchPos = logPos.m_121955_(facing.m_122436_());
                BlockState facingLog = (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)facing.m_122434_());
                BaseTreeGenerator.setBlockState(world, branchPos, facingLog);
                BaseTreeGenerator.setBlockState(world, branchPos.m_6630_(2), leaves);
                BaseTreeGenerator.setBlockState(world, branchPos.m_7495_(), leaves);
                BaseTreeGenerator.setBlockState(world, branchPos.m_5484_(facing.m_122427_(), 2), leaves);
                BaseTreeGenerator.setBlockState(world, branchPos.m_5484_(facing.m_122428_(), 2), leaves);
                for (int i = 0; i < branchLength; ++i) {
                    BlockPos pos = branchPos.m_5484_(facing, i + 1).m_6630_(i / 2 + 1);
                    BaseTreeGenerator.setBlockState(world, pos, facingLog);
                    BaseTreeGenerator.setBlockState(world, pos.m_7494_(), leaves);
                    BaseTreeGenerator.setBlockState(world, pos.m_7495_(), leaves);
                    BaseTreeGenerator.setBlockState(world, pos.m_121945_(facing.m_122427_()), leaves);
                    BaseTreeGenerator.setBlockState(world, pos.m_121945_(facing.m_122428_()), leaves);
                    if (i < branchLength - 1) continue;
                    BaseTreeGenerator.setBlockState(world, pos.m_121945_(facing), leaves);
                }
            }
        }
        BaseTreeGenerator.setBlockState(world, position.m_6630_(height), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_6630_(height).m_122012_(), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_6630_(height).m_122019_(), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_6630_(height).m_122024_(), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_6630_(height).m_122029_(), leaves);
        BaseTreeGenerator.setBlockState(world, position.m_6630_(height + 1), leaves);
        return true;
    }

    private boolean canPlace(FeaturePlaceContext<NoneFeatureConfiguration> pContext, int height) {
        for (int y = 0; y <= height + 1; ++y) {
            if (TreePlaceUtil.validTreePos(pContext.m_159774_(), pContext.m_159777_().m_6630_(y))) continue;
            return false;
        }
        BlockPos.MutableBlockPos min = pContext.m_159777_().m_122032_();
        min.m_122184_(-6, 1, -6);
        BlockPos.MutableBlockPos max = pContext.m_159777_().m_122032_();
        max.m_122184_(6, height + 4, 6);
        for (int x = min.m_123341_(); x < max.m_123341_(); ++x) {
            for (int y = min.m_123342_(); y < max.m_123342_(); ++y) {
                for (int z = min.m_123343_(); z < max.m_123343_(); ++z) {
                    if (TreePlaceUtil.validTreePos(pContext.m_159774_(), new BlockPos(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    static void setBlockState(WorldGenLevel world, BlockPos pos, BlockState state) {
        Block block = world.m_8055_(pos).m_60734_();
        if (BaseTreeGenerator.isReplaceablePlant(world, pos) || block instanceof LeavesBlock || block instanceof SaplingBlock || block instanceof RotatedPillarBlock || block == Blocks.f_50016_) {
            world.m_7731_(pos, state, 19);
        }
    }

    static boolean isReplaceablePlant(WorldGenLevel p_67289_, BlockPos p_67290_) {
        return p_67289_.m_7433_(p_67290_, state -> state.m_204336_(BlockTags.f_278394_));
    }
}

