/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen.tree;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.vit.jurassicreborn.common.worldgen.tree.BaseTreeGenerator;
import net.vit.jurassicreborn.common.worldgen.tree.TreePlaceUtil;

public class MagnoliaTreeGenerator
extends Feature<NoneFeatureConfiguration> {
    private final Supplier<BlockState> trunk;
    private final Supplier<BlockState> leaves;

    public MagnoliaTreeGenerator(Codec<NoneFeatureConfiguration> codec, Supplier<BlockState> trunk, Supplier<BlockState> leaves) {
        super(codec);
        this.trunk = trunk;
        this.leaves = leaves;
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int i;
        List<BlockPos> tips;
        int branchY;
        Direction dir2;
        RandomSource random = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        int trunkHeight = 6 + random.m_188503_(3);
        if (!this.canPlace(context, trunkHeight + 6)) {
            return false;
        }
        BlockState log = this.trunk.get();
        BlockState leaves = this.leaves.get();
        for (int y = 0; y <= trunkHeight; ++y) {
            this.setBlockState(level, origin.m_6630_(y), log);
        }
        ArrayList<BlockPos> branchTips = new ArrayList<BlockPos>();
        int branchStartHeight = 4;
        for (Direction dir2 : Direction.Plane.HORIZONTAL) {
            branchY = branchStartHeight + random.m_188503_(2);
            tips = this.createSpreadingBranch(level, origin.m_6630_(branchY), dir2, random, log, 3 + random.m_188503_(3));
            branchTips.addAll(tips);
        }
        for (i = 0; i < 3; ++i) {
            dir2 = Direction.Plane.HORIZONTAL.m_235690_(random);
            branchY = trunkHeight - 1 + random.m_188503_(2);
            tips = this.createSpreadingBranch(level, origin.m_6630_(branchY), dir2, random, log, 3 + random.m_188503_(2));
            branchTips.addAll(tips);
        }
        for (i = 0; i < 3; ++i) {
            dir2 = Direction.Plane.HORIZONTAL.m_235690_(random);
            List<BlockPos> tips2 = this.createUpwardBranch(level, origin.m_6630_(trunkHeight), dir2, random, log);
            branchTips.addAll(tips2);
        }
        for (BlockPos tip : branchTips) {
            this.addFoliageCluster(level, tip, random, leaves, 2 + random.m_188503_(2));
        }
        this.addScatteredCanopy(level, origin.m_6630_(trunkHeight - 1), random, leaves);
        return true;
    }

    private List<BlockPos> createSpreadingBranch(WorldGenLevel level, BlockPos start, Direction dir, RandomSource random, BlockState log, int length) {
        ArrayList<BlockPos> tips = new ArrayList<BlockPos>();
        BlockPos current = start;
        for (int i = 0; i < length; ++i) {
            current = current.m_121945_(dir);
            BlockState horizontalLog = (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)dir.m_122434_());
            this.setBlockState(level, current, horizontalLog);
            if (i > 0 && i % 2 == 0) {
                current = current.m_7494_();
                this.setBlockState(level, current, log);
            }
            if (i < 2 || !((double)random.m_188501_() < 0.5)) continue;
            Direction subDir = random.m_188499_() ? dir.m_122427_() : dir.m_122428_();
            BlockPos subBranch = this.createSubBranch(level, current, subDir, random, log, 2);
            tips.add(subBranch);
        }
        tips.add(current);
        return tips;
    }

    private List<BlockPos> createUpwardBranch(WorldGenLevel level, BlockPos start, Direction dir, RandomSource random, BlockState log) {
        ArrayList<BlockPos> tips = new ArrayList<BlockPos>();
        BlockPos current = start;
        int length = 2 + random.m_188503_(2);
        for (int i = 0; i < length; ++i) {
            current = current.m_7494_();
            this.setBlockState(level, current, log);
            if (i <= 0) continue;
            current = current.m_121945_(dir);
            BlockState horizontalLog = (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)dir.m_122434_());
            this.setBlockState(level, current, horizontalLog);
        }
        tips.add(current);
        return tips;
    }

    private BlockPos createSubBranch(WorldGenLevel level, BlockPos start, Direction dir, RandomSource random, BlockState log, int length) {
        BlockPos current = start;
        for (int i = 0; i < length; ++i) {
            current = current.m_121945_(dir);
            BlockState horizontalLog = (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)dir.m_122434_());
            this.setBlockState(level, current, horizontalLog);
        }
        return current;
    }

    private void addFoliageCluster(WorldGenLevel level, BlockPos center, RandomSource random, BlockState leaves, int radius) {
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos leafPos;
                    double distance = Math.sqrt(x * x + y * y + z * z);
                    if (!(distance <= (double)radius + random.m_188500_() * 0.6) || level.m_8055_(leafPos = center.m_7918_(x, y, z)).m_60713_(this.trunk.get().m_60734_())) continue;
                    this.setBlockState(level, leafPos, leaves);
                }
            }
        }
    }

    private void addScatteredCanopy(WorldGenLevel level, BlockPos center, RandomSource random, BlockState leaves) {
        for (int y = -2; y <= 3; ++y) {
            int radius = 5 - Math.abs(y - 1);
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos leafPos;
                    BlockState currentState;
                    double distance = Math.sqrt(x * x + z * z);
                    double probability = 1.0 - distance / (double)(radius + 1) * 0.7;
                    if (!(distance <= (double)radius) || !(random.m_188500_() < probability) || !(currentState = level.m_8055_(leafPos = center.m_7918_(x, y, z))).m_60795_()) continue;
                    this.setBlockState(level, leafPos, leaves);
                }
            }
        }
    }

    private boolean canPlace(FeaturePlaceContext<NoneFeatureConfiguration> context, int height) {
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        BlockPos.MutableBlockPos min = origin.m_122032_();
        min.m_122184_(-8, 0, -8);
        BlockPos.MutableBlockPos max = origin.m_122032_();
        max.m_122184_(8, height + 2, 8);
        for (int x = min.m_123341_(); x <= max.m_123341_(); ++x) {
            for (int y = min.m_123342_(); y <= max.m_123342_(); ++y) {
                for (int z = min.m_123343_(); z <= max.m_123343_(); ++z) {
                    if (TreePlaceUtil.validTreePos(level, new BlockPos(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void setBlockState(WorldGenLevel world, BlockPos pos, BlockState state) {
        BaseTreeGenerator.setBlockState(world, pos, state);
    }
}

