/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen.villager;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class JurassicStructureMapForEmeralds
implements VillagerTrades.ItemListing {
    private static final float PRICE_MULTIPLIER = 0.2f;
    private final int emeraldCost;
    private final ResourceKey<Structure> structureKey;
    private final MapDecoration.Type markerType;
    private final int maxUses;
    private final int villagerXp;
    private final String translationKey;

    public JurassicStructureMapForEmeralds(int emeraldCost, ResourceKey<Structure> structureKey, String translationKey) {
        this(emeraldCost, structureKey, MapDecoration.Type.RED_X, 12, 5, translationKey);
    }

    public JurassicStructureMapForEmeralds(int emeraldCost, ResourceKey<Structure> structureKey, MapDecoration.Type markerType, int maxUses, int villagerXp, String translationKey) {
        this.emeraldCost = emeraldCost;
        this.structureKey = structureKey;
        this.markerType = markerType;
        this.maxUses = maxUses;
        this.villagerXp = villagerXp;
        this.translationKey = translationKey;
    }

    public MerchantOffer m_213663_(Entity trader, RandomSource random) {
        Level level = trader.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Registry registry = serverLevel.m_9598_().m_175515_(Registries.f_256944_);
        Optional structureHolder = registry.m_203636_(this.structureKey);
        if (structureHolder.isEmpty()) {
            return null;
        }
        HolderSet.Direct structures = HolderSet.m_205809_((Holder[])new Holder[]{(Holder)structureHolder.get()});
        ChunkGenerator generator = serverLevel.m_7726_().m_8481_();
        Optional<Pair> result = Optional.ofNullable(generator.m_223037_(serverLevel, (HolderSet)structures, trader.m_20183_(), 100, true));
        if (result.isEmpty()) {
            return null;
        }
        BlockPos structurePos = (BlockPos)result.get().getFirst();
        ItemStack map = MapItem.m_42886_((Level)serverLevel, (int)structurePos.m_123341_(), (int)structurePos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
        MapItem.m_42850_((ServerLevel)serverLevel, (ItemStack)map);
        MapItemSavedData.m_77925_((ItemStack)map, (BlockPos)structurePos, (String)"+", (MapDecoration.Type)this.markerType);
        map.m_41714_((Component)Component.m_237115_((String)this.translationKey));
        return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldCost), new ItemStack((ItemLike)Items.f_42522_), map, this.maxUses, this.villagerXp, 0.2f);
    }
}

