/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen.villager;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.blocks.entities.DNABlocks.DNASequencer.DNASequencerBlock;
import net.vit.jurassicreborn.common.blocks.entities.cleaner.CleanerBlock;

public class ModVillagers {
    public static final DeferredRegister<PoiType> POI_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"jurassicreborn");
    public static final DeferredRegister<VillagerProfession> VILLAGER_PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)"jurassicreborn");
    public static final RegistryObject<PoiType> CLEANING_STATION_POI = POI_TYPES.register("cleaning_station_poi", () -> new PoiType((Set)ImmutableSet.copyOf((Collection)((CleanerBlock)((Object)((Object)ModBlocks.CLEANING_STATION.get()))).m_49965_().m_61056_()), 1, 1));
    public static final RegistryObject<VillagerProfession> PALEONTOLOGIST = VILLAGER_PROFESSIONS.register("paleontologist", () -> new VillagerProfession("paleontologist", x -> x.get() == CLEANING_STATION_POI.get(), x -> x.get() == CLEANING_STATION_POI.get(), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.f_12572_));
    public static final RegistryObject<PoiType> DNA_SEQUENCER_POI = POI_TYPES.register("dna_sequencer_poi", () -> new PoiType((Set)ImmutableSet.copyOf((Collection)((DNASequencerBlock)((Object)((Object)ModBlocks.DNA_SEQUENCER.get()))).m_49965_().m_61056_()), 1, 1));
    public static final RegistryObject<VillagerProfession> GENETICIST = VILLAGER_PROFESSIONS.register("geneticist", () -> new VillagerProfession("geneticist", x -> x.get() == DNA_SEQUENCER_POI.get(), x -> x.get() == DNA_SEQUENCER_POI.get(), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.f_12571_));

    public static void registerPOIs() {
        try {
            Method method = ObfuscationReflectionHelper.findMethod(PoiType.class, (String)"registerBlockStates", (Class[])new Class[]{PoiType.class});
            method.invoke(null, CLEANING_STATION_POI.get());
            method.invoke(null, DNA_SEQUENCER_POI.get());
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
    }

    public static void register(IEventBus eventBus) {
        POI_TYPES.register(eventBus);
        VILLAGER_PROFESSIONS.register(eventBus);
    }
}

