/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.vit.jurassicreborn.common.entities.vehicle.VehicleEntity;
import net.vit.jurassicreborn.common.entities.vehicle.WheelParticleData;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="jurassicreborn", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class TyretrackRenderer {
    public static final List<Material> ALLOWED_MATERIALS = List.of(Material.f_76315_, Material.f_76314_, Material.f_76317_);
    public static final ResourceLocation TYRE_TRACKS = new ResourceLocation("jurassicreborn", "textures/misc/tyre-tracks.png");
    private static final List<List<WheelParticleData>> DEAD_CARS_LISTS = Lists.newArrayList();

    @SubscribeEvent
    public static void onRenderStage(RenderLevelStageEvent e) {
        if (e.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (!(level instanceof ClientLevel)) {
            return;
        }
        ClientLevel clientLevel = level;
        Vec3 camPos = mc.f_91063_.m_109153_().m_90583_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(() -> {
            Minecraft minecraft = Minecraft.m_91087_();
            return minecraft.f_91063_.m_172820_();
        });
        RenderSystem.m_157456_((int)0, (ResourceLocation)TYRE_TRACKS);
        BufferBuilder buf = Tesselator.m_85913_().m_85915_();
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        ArrayList runList = Lists.newArrayList();
        for (Entity ent : clientLevel.m_104735_()) {
            if (!(ent instanceof VehicleEntity)) continue;
            VehicleEntity car = (VehicleEntity)ent;
            for (List<WheelParticleData> list2 : car.wheelDataList) {
                TyretrackRenderer.pushListQuads(list2, buf, e.getPartialTick(), runList, (Level)clientLevel, camPos);
            }
        }
        DEAD_CARS_LISTS.forEach(list -> TyretrackRenderer.pushListQuads(list, buf, e.getPartialTick(), runList, (Level)clientLevel, camPos));
        runList.sort(Comparator.comparing(Pair::getLeft, Comparator.reverseOrder()));
        runList.forEach(p -> ((Runnable)p.getRight()).run());
        Tesselator.m_85913_().m_85914_();
        RenderSystem.m_69461_();
    }

    private static void pushListQuads(List<WheelParticleData> data, BufferBuilder buf, float pt, List<Pair<Long, Runnable>> out, Level level, Vec3 camPos) {
        for (int i = 0; i < data.size() - 1; ++i) {
            WheelParticleData a = data.get(i);
            WheelParticleData b = data.get(i + 1);
            if (!a.shouldRender()) continue;
            Vec3 sv = a.getPosition();
            Vec3 ev = b.getPosition();
            Vec3 svOpp = a.getOppositePosition();
            Vec3 evOpp = b.getOppositePosition();
            BlockPos sPos = new BlockPos(sv);
            BlockPos ePos = new BlockPos(ev);
            if (sv.f_82480_ != ev.f_82480_ || !TyretrackRenderer.isAccepted(level, sPos) || !TyretrackRenderer.isAccepted(level, ePos)) continue;
            int idx = i;
            out.add((Pair<Long, Runnable>)Pair.of((Object)a.getWorldTime(), () -> {
                double d = 0.5 / sv.m_82554_(svOpp);
                Vec3 vA = svOpp.m_82546_(sv).m_82490_(d);
                double d1 = 0.5 / ev.m_82554_(evOpp);
                Vec3 vB = evOpp.m_82546_(ev).m_82490_(d1);
                float lightA = level.m_45517_(LightLayer.BLOCK, sPos);
                float lightB = level.m_45517_(LightLayer.BLOCK, ePos);
                float alphaA = a.getAlpha(pt);
                float alphaB = b.getAlpha(pt);
                double off = (double)(idx + 2) * 1.0E-4;
                TyretrackRenderer.quad(buf, sv, vA, ev, vB, off, lightA, lightB, alphaA, alphaB, camPos);
                TyretrackRenderer.quad(buf, sv, vA, ev, vB, off, lightA, lightB, alphaA, alphaB, camPos, true);
            }));
        }
    }

    private static void quad(BufferBuilder buf, Vec3 sv, Vec3 vA, Vec3 ev, Vec3 vB, double off, float lightA, float lightB, float alphaA, float alphaB, Vec3 camPos) {
        TyretrackRenderer.quad(buf, sv, vA, ev, vB, off, lightA, lightB, alphaA, alphaB, camPos, false);
    }

    private static void quad(BufferBuilder buf, Vec3 sv, Vec3 vA, Vec3 ev, Vec3 vB, double off, float lightA, float lightB, float alphaA, float alphaB, Vec3 camPos, boolean flip) {
        if (flip) {
            buf.m_5483_(ev.f_82479_ - camPos.f_82479_ - vB.f_82479_, ev.f_82480_ - camPos.f_82480_ + off, ev.f_82481_ - camPos.f_82481_ - vB.f_82481_).m_7421_(1.0f, 1.0f).m_85950_(lightB, lightB, lightB, alphaB).m_5752_();
            buf.m_5483_(ev.f_82479_ - camPos.f_82479_ + vB.f_82479_, ev.f_82480_ - camPos.f_82480_ + off, ev.f_82481_ - camPos.f_82481_ + vB.f_82481_).m_7421_(1.0f, 0.0f).m_85950_(lightB, lightB, lightB, alphaB).m_5752_();
            buf.m_5483_(sv.f_82479_ - camPos.f_82479_ + vA.f_82479_, sv.f_82480_ - camPos.f_82480_ + off, sv.f_82481_ - camPos.f_82481_ + vA.f_82481_).m_7421_(0.0f, 0.0f).m_85950_(lightA, lightA, lightA, alphaA).m_5752_();
            buf.m_5483_(sv.f_82479_ - camPos.f_82479_ - vA.f_82479_, sv.f_82480_ - camPos.f_82480_ + off, sv.f_82481_ - camPos.f_82481_ - vA.f_82481_).m_7421_(0.0f, 1.0f).m_85950_(lightA, lightA, lightA, alphaA).m_5752_();
        } else {
            buf.m_5483_(sv.f_82479_ - camPos.f_82479_ + vA.f_82479_, sv.f_82480_ - camPos.f_82480_ + off, sv.f_82481_ - camPos.f_82481_ + vA.f_82481_).m_7421_(0.0f, 0.0f).m_85950_(lightA, lightA, lightA, alphaA).m_5752_();
            buf.m_5483_(sv.f_82479_ - camPos.f_82479_ - vA.f_82479_, sv.f_82480_ - camPos.f_82480_ + off, sv.f_82481_ - camPos.f_82481_ - vA.f_82481_).m_7421_(0.0f, 1.0f).m_85950_(lightA, lightA, lightA, alphaA).m_5752_();
            buf.m_5483_(ev.f_82479_ - camPos.f_82479_ - vB.f_82479_, ev.f_82480_ - camPos.f_82480_ + off, ev.f_82481_ - camPos.f_82481_ - vB.f_82481_).m_7421_(1.0f, 1.0f).m_85950_(lightB, lightB, lightB, alphaB).m_5752_();
            buf.m_5483_(ev.f_82479_ - camPos.f_82479_ + vB.f_82479_, ev.f_82480_ - camPos.f_82480_ + off, ev.f_82481_ - camPos.f_82481_ + vB.f_82481_).m_7421_(1.0f, 0.0f).m_85950_(lightB, lightB, lightB, alphaB).m_5752_();
        }
    }

    private static boolean isAccepted(Level level, BlockPos pos) {
        BlockState ground = level.m_8055_(pos);
        return ALLOWED_MATERIALS.contains(ground.m_60767_()) && ground.m_60783_((BlockGetter)level, pos, Direction.UP) && level.m_8055_(pos.m_7494_()).m_60767_() != Material.f_76305_;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            return;
        }
        DEAD_CARS_LISTS.removeIf(list -> {
            ArrayList dead = Lists.newArrayList();
            list.forEach(w -> w.tick(dead));
            dead.forEach(list::remove);
            return list.isEmpty();
        });
    }

    public static void uploadList(VehicleEntity v) {
        if (!v.f_19853_.f_46443_) {
            return;
        }
        for (List<WheelParticleData> l : v.wheelDataList) {
            DEAD_CARS_LISTS.add(0, l);
        }
    }
}

