/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity.animation.entity;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import net.vit.jurassicreborn.client.model.AnimatableModel;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimator;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.GiganotosaurusEntity;

public class GiganotosaurusAnimator
extends EntityAnimator<GiganotosaurusEntity> {
    @Override
    protected void performAnimations(AnimatableModel model, GiganotosaurusEntity entity, float limbSwing, float limbSwingAmount, float ticks, float rotationYaw, float rotationPitch, float scale) {
        AdvancedModelBox body1 = model.getCube("Body");
        AdvancedModelBox neck1 = model.getCube("Neck");
        AdvancedModelBox jaw = model.getCube("Jaw");
        AdvancedModelBox tail1 = model.getCube("Tail");
        AdvancedModelBox tail2 = model.getCube("Tail2");
        AdvancedModelBox tail3 = model.getCube("Tail3");
        AdvancedModelBox tail4 = model.getCube("Tail4");
        AdvancedModelBox tail5 = model.getCube("Tail5");
        AdvancedModelBox tail6 = model.getCube("Tail6");
        AdvancedModelBox tail7 = model.getCube("Tail7");
        AdvancedModelBox tail8 = model.getCube("Tail8");
        AdvancedModelBox[] torso = new AdvancedModelBox[]{body1};
        AdvancedModelBox[] neckChain = new AdvancedModelBox[]{neck1};
        AdvancedModelBox[] tailChain = new AdvancedModelBox[]{tail8, tail7, tail6, tail5, tail4, tail3, tail2, tail1};
        float idleSpeed = 0.1f;
        float idleDeg = 0.1f;
        float walkSpeed = 0.6f;
        float walkDeg = 0.12f;
        float tailIdleSpeed = idleSpeed / 2.0f;
        float tailWalkSpeed = walkSpeed / 2.0f;
        if (body1 != null) {
            model.bob(body1, idleSpeed, 0.35f, false, ticks, 1.0f);
        }
        if (torso.length > 0) {
            model.chainWave(torso, idleSpeed, idleDeg * 0.45f, 2.0, ticks, 1.0f);
        }
        if (neckChain.length > 0) {
            model.chainWave(neckChain, idleSpeed * 0.9f, idleDeg * 0.3f, -2.0, ticks, 1.0f);
            model.chainSwing(neckChain, idleSpeed * 0.8f, idleDeg * 0.25f, -2.0, ticks, 1.0f);
        }
        model.faceTarget(rotationYaw, rotationPitch, 1.0f, neck1);
        if (jaw != null && !entity.isCarcass()) {
            jaw.rotateAngleX = (float)((double)jaw.rotateAngleX + Math.sin(ticks * 0.07f) * (double)0.02f);
        }
        if (tailChain.length > 0) {
            model.chainSwing(tailChain, tailIdleSpeed, 0.12f, -2.0, ticks, 1.0f);
            model.chainWave(tailChain, tailIdleSpeed * 0.8f, 0.03f, -2.0, ticks, 1.0f);
            if (limbSwingAmount > 0.1f) {
                model.chainSwing(tailChain, tailWalkSpeed, walkDeg, -2.0, limbSwing, limbSwingAmount);
            }
            entity.tailBuffer.applyChainSwingBuffer(tailChain);
        }
    }
}

