/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.vit.jurassicreborn.common.blocks.entities.ActionFigureBlockEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.items.ModItems;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionFigureBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public ActionFigureBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ActionFigureBlockEntity(pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ActionFigureBlock.getBounds(level, pos);
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    private static VoxelShape getBounds(BlockGetter world, BlockPos pos) {
        BlockEntity entity = world.m_7702_(pos);
        if (entity instanceof ActionFigureBlockEntity) {
            ActionFigureBlockEntity displayEntity = (ActionFigureBlockEntity)entity;
            DinosaurEntity dinoEntity = displayEntity.getEntity();
            if (dinoEntity == null) {
                return Shapes.m_83040_();
            }
            Dinosaur dinosaur = dinoEntity.getDinosaur();
            if (!displayEntity.isSkeleton()) {
                Dinosaur metadata = dinosaur;
                float width = Mth.m_14036_((float)(metadata.getAdultSizeX() * 0.25f), (float)0.1f, (float)1.0f);
                float height = Mth.m_14036_((float)(metadata.getAdultSizeY() * 0.25f), (float)0.1f, (float)1.0f);
                float halfWidth = width / 2.0f;
                width *= 16.0f;
                return Block.m_49796_((double)(8.0f - (halfWidth *= 16.0f)), (double)0.0, (double)(8.0f - halfWidth), (double)(halfWidth + 8.0f), (double)(height *= 16.0f), (double)(halfWidth + 8.0f));
            }
            return Block.m_49796_((double)0.01, (double)0.01, (double)0.01, (double)15.99, (double)15.99, (double)15.99);
        }
        return Shapes.m_83040_();
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return super.m_7898_(state, level, pos) && ActionFigureBlock.canBlockStay(level, pos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        this.checkAndDropBlock(level, pos, state);
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        super.m_7455_(state, level, pos, random);
        this.checkAndDropBlock((Level)level, pos, state);
    }

    private void checkAndDropBlock(Level world, BlockPos pos, BlockState state) {
        if (!ActionFigureBlock.canBlockStay((LevelReader)world, pos)) {
            List drops = this.m_7381_(state, new LootContext.Builder((ServerLevel)world).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78984_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81455_, null).m_78984_(LootContextParams.f_81462_, (Object)world.m_7702_(pos)));
            for (Object drop : drops) {
                Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)((ItemStack)drop));
            }
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    private static boolean canBlockStay(LevelReader world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_60767_().m_76333_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return ActionFigureBlock.getItemFromTile(this.getTile((Level)level, pos));
    }

    public ActionFigureBlockEntity getTile(Level world, BlockPos pos) {
        return (ActionFigureBlockEntity)world.m_7702_(pos);
    }

    private static ItemStack getItemFromTile(ActionFigureBlockEntity tile) {
        int variant = tile.getVariant();
        if (tile.isSkeleton()) {
            variant = tile.isMale() ? 1 : 2;
        }
        Dinosaur dino = tile.getEntity().getDinosaur();
        boolean skeleton = tile.isSkeleton();
        if (skeleton && tile.isFossile() && dino.isHybrid()) {
            return ItemStack.f_41583_;
        }
        Item item = skeleton ? (tile.isFossile() ? (Item)ModItems.FOSSIL_SKELETONS.get(dino).get() : (Item)ModItems.FRESH_SKELETONS.get(dino).get()) : (Item)ModItems.ACTION_FIGURES.get(dino).get();
        ItemStack stack = new ItemStack((ItemLike)item);
        CompoundTag nbt = new CompoundTag();
        nbt.m_128344_("Gender", (byte)(tile.isMale() ? 1 : 2));
        nbt.m_128379_("IsFossile", tile.isFossile());
        nbt.m_128379_("IsSkeleton", tile.isSkeleton());
        nbt.m_128359_("Dinosaur", dino.getName());
        nbt.m_128344_("Variant", tile.getVariant());
        stack.m_41751_(nbt);
        return stack;
    }

    public List m_7381_(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(1);
        BlockPos pos = new BlockPos((Vec3)builder.m_78970_(LootContextParams.f_81460_));
        BlockEntity blockEntity = builder.m_78962_().m_7702_(pos);
        if (blockEntity instanceof ActionFigureBlockEntity) {
            ActionFigureBlockEntity tile = (ActionFigureBlockEntity)blockEntity;
            Dinosaur dino = tile.getEntity().getDinosaur();
            if (tile.isFossile() && tile.isSkeleton() && dino.isHybrid()) {
                return drops;
            }
            ItemStack item = ActionFigureBlock.getItemFromTile(tile);
            if (!item.m_41619_()) {
                drops.add(item);
            }
        }
        return drops;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack) {
        if (blockEntity instanceof ActionFigureBlockEntity) {
            ItemStack itemStack = ActionFigureBlock.getItemFromTile((ActionFigureBlockEntity)blockEntity);
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)itemStack);
        }
        super.m_6240_(level, player, pos, state, blockEntity, stack);
    }

    @Nullable
    public BlockEntityTicker m_142354_(Level level, BlockState state, BlockEntityType blockEntityType) {
        return (level1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof ActionFigureBlockEntity) {
                ActionFigureBlockEntity actionFigure = (ActionFigureBlockEntity)blockEntity;
                actionFigure.tick(level1, pos, state1, actionFigure);
            }
        };
    }
}

