/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.common.blocks.entities.ModBlockEntities;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.entities.IHasVariants;
import org.jetbrains.annotations.NotNull;

public class ActionFigureBlockEntity
extends BlockEntity {
    protected boolean suppressUpdates = false;
    private Dinosaur dinosaur = DinosaurHandler.VELOCIRAPTOR;
    private DinosaurEntity entity;
    private EntityType<? extends DinosaurEntity> entityType;
    private int rotation;
    private boolean isFossile;
    private boolean isMale;
    private static final byte NO_VARIANT = -1;
    private byte variant = (byte)-1;
    private boolean isSkeleton;
    private CompoundTag entityTag;

    public ActionFigureBlockEntity(BlockEntityType<? extends ActionFigureBlockEntity> type, BlockPos pWorldPosition, BlockState pBlockState) {
        super(type, pWorldPosition, pBlockState);
    }

    public ActionFigureBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        this((BlockEntityType<? extends ActionFigureBlockEntity>)((BlockEntityType)ModBlockEntities.DISPLAY_BLOCK_ENTITY.get()), pWorldPosition, pBlockState);
    }

    public void onLoad() {
        this.checkAndLoadEntity();
    }

    public void setDinosaur(Dinosaur dino, boolean gender, boolean isSkeleton, boolean isFossile) {
        this.dinosaur = dino;
        this.isMale = gender;
        this.isSkeleton = isSkeleton;
        this.isFossile = isFossile;
        this.loadEntityType();
        if (this.f_58857_ != null && this.entityType != null) {
            this.entity = (DinosaurEntity)this.entityType.m_20615_(this.f_58857_);
            this.initializeEntity(this.entity);
            if (!this.f_58857_.f_46443_ && !this.suppressUpdates) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        } else {
            this.entity = null;
        }
        this.m_6596_();
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void setDinosaur(Dinosaur dino, boolean gender, boolean isSkeleton, boolean isFossile, CompoundTag entityTag) {
        this.dinosaur = dino;
        this.isMale = gender;
        this.isSkeleton = isSkeleton;
        this.isFossile = isFossile;
        this.entityTag = entityTag.m_6426_();
        this.loadEntityType();
        if (this.f_58857_ != null && this.entityType != null) {
            this.entity = (DinosaurEntity)this.entityType.m_20615_(this.f_58857_);
            this.initializeEntity(this.entity, entityTag);
            if (!this.f_58857_.f_46443_ && !this.suppressUpdates) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        } else {
            this.entity = null;
        }
        this.m_6596_();
    }

    public void loadEntityType() {
        RegistryObject<? extends EntityType<? extends DinosaurEntity>> registry = DinosaurEntity.CLASS_TYPE_LIST.get(this.dinosaur.getDinosaurClass());
        this.entityType = registry != null ? (EntityType)registry.get() : null;
    }

    public void checkAndLoadEntity() {
        if (this.entity != null) {
            return;
        }
        this.loadEntityType();
        if (this.entity == null && this.entityType != null) {
            this.entity = (DinosaurEntity)this.entityType.m_20615_(this.f_58857_);
            if (this.entity != null) {
                if (this.entityTag != null && !this.entityTag.m_128456_()) {
                    this.initializeEntity(this.entity, this.entityTag);
                } else {
                    this.initializeEntity(this.entity);
                }
            }
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        String dinoName = nbt.m_128461_("Dinosaur");
        Dinosaur dinosaur = Dinosaur.getDinosaurByName(dinoName);
        boolean isMale = !nbt.m_128441_("IsMale") || nbt.m_128471_("IsMale");
        boolean isSkeleton = nbt.m_128471_("IsSkeleton");
        if (!nbt.m_128441_("IsFossile")) {
            nbt.m_128379_("IsFossile", false);
        }
        this.isFossile = nbt.m_128471_("IsFossile");
        this.dinosaur = dinosaur;
        this.isMale = isMale;
        this.isSkeleton = isSkeleton;
        this.isFossile = nbt.m_128471_("IsFossile");
        this.entityTag = nbt.m_128469_("DinosaurTag").m_6426_();
        this.entity = null;
        this.loadEntityType();
        this.dinosaur = dinosaur;
        this.rotation = nbt.m_128451_("Rotation");
        this.variant = nbt.m_128425_("Variant", 1) ? nbt.m_128445_("Variant") : (byte)-1;
    }

    public void m_183515_(@NotNull CompoundTag nbt) {
        if (this.entity != null) {
            this.syncVariantFromEntity();
            CompoundTag tag = this.entity.serializeNBT();
            tag.m_128473_("UUID");
            nbt.m_128365_("DinosaurTag", (Tag)tag);
        }
        nbt.m_128359_("Dinosaur", this.dinosaur.getName());
        nbt.m_128405_("Rotation", this.rotation);
        nbt.m_128379_("IsMale", this.isMale);
        nbt.m_128379_("IsSkeleton", this.isSkeleton);
        nbt.m_128344_("Variant", this.variant);
        nbt.m_128379_("IsFossile", this.isFossile);
    }

    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_187482_);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag data = pkt.m_131708_();
        this.m_142466_(data);
        this.checkAndLoadEntity();
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public AABB getRenderBoundingBox() {
        if (this.isSkeleton) {
            if (this.entity == null) {
                this.checkAndLoadEntity();
            }
            if (this.entity != null) {
                return this.entity.m_6921_().m_82383_(Vec3.m_82528_((Vec3i)this.f_58858_)).m_82400_(3.0);
            }
        }
        return super.getRenderBoundingBox();
    }

    public boolean isMale() {
        return this.isMale;
    }

    public boolean isSkeleton() {
        return this.isSkeleton;
    }

    public boolean isFossile() {
        return this.isFossile;
    }

    public void setVariant(byte variant) {
        this.variant = variant;
        if (this.entity != null) {
            this.applyVariantToEntity(this.entity);
            this.markUpdated();
        } else {
            this.m_6596_();
        }
    }

    public byte getVariant() {
        return this.variant;
    }

    public int getRot() {
        return this.rotation;
    }

    protected void setRotationSilently(int rotation) {
        this.rotation = Math.floorMod(rotation, 360);
    }

    public void setRot(int rotation) {
        this.setRotationSilently(rotation);
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && !this.suppressUpdates) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public DinosaurEntity getEntity() {
        if (this.entity == null) {
            this.entity = this.createEntity();
        }
        return this.entity;
    }

    private DinosaurEntity createEntity() {
        this.checkAndLoadEntity();
        if (this.entity == null && this.entityType != null) {
            this.entity = (DinosaurEntity)this.entityType.m_20615_(this.f_58857_);
            if (this.entity != null) {
                this.initializeEntity(this.entity);
            }
        }
        return this.entity;
    }

    private void initializeEntity(DinosaurEntity entity) {
        entity.setSkeleton(this.isSkeleton);
        entity.setupDisplay(this.isMale);
        this.applyVariantToEntity(entity);
        entity.setIsFossile(this.isFossile);
        entity.setAnimation(EntityAnimation.IDLE.get());
        entity.m_21557_(true);
    }

    private void initializeEntity(DinosaurEntity entity, CompoundTag entityTag) {
        entity.m_20258_(entityTag);
        entity.setSkeleton(this.isSkeleton);
        entity.setupDisplay(this.isMale);
        this.applyVariantToEntity(entity);
        entity.setIsFossile(this.isFossile);
        entity.setAnimation(EntityAnimation.IDLE.get());
        entity.m_21557_(true);
    }

    private void applyVariantToEntity(DinosaurEntity entity) {
        if (entity == null) {
            return;
        }
        if (this.isSkeleton) {
            if (this.variant != -1) {
                entity.setSkeletonVariant(this.variant);
            }
            this.variant = entity.getSkeletonVariant();
        } else if (entity instanceof IHasVariants) {
            IHasVariants variantHolder = (IHasVariants)((Object)entity);
            if (this.variant != -1) {
                variantHolder.setVariant(Byte.toUnsignedInt(this.variant));
            }
            this.variant = (byte)variantHolder.getVariant();
        }
    }

    private void syncVariantFromEntity() {
        if (this.entity == null) {
            return;
        }
        if (this.isSkeleton) {
            this.variant = this.entity.getSkeletonVariant();
        } else {
            DinosaurEntity dinosaurEntity = this.entity;
            if (dinosaurEntity instanceof IHasVariants) {
                IHasVariants variantHolder = (IHasVariants)((Object)dinosaurEntity);
                this.variant = (byte)variantHolder.getVariant();
            }
        }
    }

    private void markUpdated() {
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && !this.suppressUpdates) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void tick(Level world, BlockPos pPos, BlockState pState, ActionFigureBlockEntity pBlockEntity) {
    }

    public DinosaurEntity peekEntity() {
        return this.entity;
    }
}

