/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.skeletonassembly;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import net.vit.jurassicreborn.common.blocks.entities.ModBlockEntities;
import net.vit.jurassicreborn.common.blocks.entities.skeletonassembly.SkeletonAssemblerBlockEntity;

public class SkeletonAssemblyBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<BlockHalf> HALF = EnumProperty.m_61587_((String)"half", BlockHalf.class);

    public SkeletonAssemblyBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(2.0f).m_60918_(SoundType.f_56743_).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)((Object)BlockHalf.MAIN)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity be;
        BlockPos menuPos;
        BlockPos blockPos = menuPos = state.m_61143_(HALF) == BlockHalf.DUMMY ? this.getOpposite(pos, state) : pos;
        if (!level.f_46443_ && (be = level.m_7702_(menuPos)) instanceof MenuProvider) {
            MenuProvider provider = (MenuProvider)be;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                NetworkHooks.openGui((ServerPlayer)sp, (MenuProvider)provider, (BlockPos)menuPos);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState main;
        Direction facing = ctx.m_8125_().m_122424_();
        BlockPos pos = ctx.m_8083_();
        Level level = ctx.m_43725_();
        if (!level.m_8055_(this.getOpposite(pos, main = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing))).m_60629_(ctx)) {
            return null;
        }
        return main;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockPos other = this.getOpposite(pos, state);
        level.m_7731_(other, (BlockState)state.m_61124_(HALF, (Comparable)((Object)BlockHalf.DUMMY)), 3);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockPos mainPos;
            BlockEntity be;
            BlockPos other = this.getOpposite(pos, state);
            if (level.m_8055_(other).m_60734_() == this) {
                level.m_7471_(other, false);
            }
            if ((be = level.m_7702_(mainPos = state.m_61143_(HALF) == BlockHalf.MAIN ? pos : other)) instanceof SkeletonAssemblerBlockEntity) {
                SkeletonAssemblerBlockEntity assembler = (SkeletonAssemblerBlockEntity)be;
                Containers.m_19002_((Level)level, (BlockPos)mainPos, (Container)((Container)assembler.getItemHandler()));
                level.m_46717_(mainPos, (Block)this);
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    private BlockPos getOpposite(BlockPos pos, BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        BlockHalf half = (BlockHalf)((Object)state.m_61143_(HALF));
        return pos.m_142300_(half == BlockHalf.MAIN ? dir.m_122427_() : dir.m_122428_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HALF});
    }

    public RenderShape m_7514_(BlockState state) {
        return state.m_61143_(HALF) == BlockHalf.MAIN ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    public boolean m_6104_(BlockState state, BlockState adjacent, Direction side) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return state.m_61143_(HALF) == BlockHalf.MAIN ? new SkeletonAssemblerBlockEntity(pos, state) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level lvl, BlockState state, BlockEntityType<T> type) {
        return state.m_61143_(HALF) == BlockHalf.MAIN && type == ModBlockEntities.SKELETON_ASSEMBLY_ENTITY.get() ? (w, p, s, be) -> SkeletonAssemblerBlockEntity.tick(w, p, s, (SkeletonAssemblerBlockEntity)be) : null;
    }

    public static enum BlockHalf implements StringRepresentable
    {
        MAIN,
        DUMMY;


        public String m_7912_() {
            return this == MAIN ? "main" : "dummy";
        }
    }
}

