/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.fossil;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.RegistryObject;
import net.vit.jurassicreborn.common.blocks.entities.EncasedFaunaFossilBlockEntity;
import net.vit.jurassicreborn.common.blocks.fossil.EncasedFossil;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.util.FossilUtil;
import net.vit.jurassicreborn.common.util.ItemsUtil;
import net.vit.jurassicreborn.common.util.api.CleanableItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncasedFaunaFossilBlock
extends Block
implements EncasedFossil,
EntityBlock,
CleanableItem {
    private final Dinosaur defaultDino;

    public EncasedFaunaFossilBlock(BlockBehaviour.Properties properties, Dinosaur defaultDino) {
        super(properties);
        this.defaultDino = defaultDino;
    }

    private Dinosaur readDino(ItemStack stack) {
        Dinosaur dino = FossilUtil.getDino(stack);
        return dino == null || dino == Dinosaur.EMPTY ? this.defaultDino : dino;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new EncasedFaunaFossilBlockEntity(pos, state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof EncasedFaunaFossilBlockEntity) {
            EncasedFaunaFossilBlockEntity fossilBe = (EncasedFaunaFossilBlockEntity)be;
            ItemStack stack = new ItemStack((ItemLike)this);
            fossilBe.m_187476_(stack);
            return stack;
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    @Override
    public boolean isCleanable(ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack getCleanedItem(ItemStack stack, Random random) {
        Dinosaur dino = this.readDino(stack);
        String[] bones = dino.getBones();
        LinkedHashMap<String, RegistryObject<Item>> boneMap = ModItems.BONES.get(dino);
        if (boneMap == null || bones == null || bones.length == 0) {
            return ItemStack.f_41583_;
        }
        String boneKey = bones.length > 1 ? bones[random.nextInt(bones.length)] : bones[0];
        Item bone = (Item)boneMap.get(boneKey).get();
        return new ItemStack((ItemLike)bone);
    }

    @Override
    public List<Pair<Float, ItemStack>> getChancedOutputs(ItemStack inputItem) {
        Dinosaur dino = this.readDino(inputItem);
        String[] bones = dino.getBones();
        if (bones == null || bones.length == 0) {
            return new ArrayList<Pair<Float, ItemStack>>();
        }
        float chance = 100.0f / (float)bones.length;
        ArrayList<Pair<Float, ItemStack>> list = new ArrayList<Pair<Float, ItemStack>>();
        for (String bone : bones) {
            Item boneItem = ItemsUtil.getFossilDinosaurBone(dino, bone);
            if (boneItem == null) continue;
            list.add((Pair<Float, ItemStack>)Pair.of((Object)Float.valueOf(chance), (Object)new ItemStack((ItemLike)boneItem)));
        }
        return list;
    }
}

