/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.AnkylosaurusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class AnkylosaurusDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.35f;

    public AnkylosaurusDinosaur() {
        this.setName("Ankylosaurus");
        this.setScientificName("Ankylosaurus Magniventris");
        this.setFamily("Ankylosauridae");
        this.setLocation("United States");
        this.setDinosaurType(Dinosaur.DinosaurType.NEUTRAL);
        this.setDinosaurClass(AnkylosaurusEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(11246466, 8151664);
        this.setEggColorFemale(0x554E45, 4143413);
        this.setHealth(20.0, 120.0);
        this.setSpeed(0.29999999403953553, 0.35f);
        this.setStrength(6.0, 40.0);
        this.setMaximumAge(this.fromDays(50));
        this.setEyeHeight(0.29f, 2.0f);
        this.setSizeX(0.3f, 3.0f);
        this.setSizeY(0.3f, 3.0f);
        this.setStorage(27);
        this.setDiet(Diet.HERBIVORE.get());
        this.setBones("armor_plating", "front_leg_bones", "hind_leg_bones", "neck_vertebrae", "pelvis", "ribcage", "shoulder", "skull", "tail_club", "tail_vertebrae", "tooth");
        this.setHeadCubeName("head ");
        this.setScale(2.2f, 0.15f);
        this.setBreeding(false, 0, 6, 44, false, true);
        this.setImprintable(true);
        this.setDefendOwner(true);
        this.setStorage(24);
        this.shouldDefendOffspring();
        String[][] recipe = new String[][]{{"tail_club", "armor_plating", "", "", ""}, {"tail_vertebrae", "pelvis", "ribcage", "neck_vertebrae", "skull"}, {"hind_leg_bones", "hind_leg_bones", "", "shoulder", "tooth"}, {"", "", "", "front_leg_bones", "front_leg_bones"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207592_, BiomeTags.f_207611_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

