/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ApatosaurusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class ApatosaurusDinosaur
extends Dinosaur {
    public static final double SPEED = 0.25;

    public ApatosaurusDinosaur() {
        this.setName("Apatosaurus");
        this.setScientificName("Apatosaurus ajax");
        this.setFamily("Diplodocidae");
        this.setLocation("United States");
        this.setDinosaurType(Dinosaur.DinosaurType.PASSIVE);
        this.setDinosaurClass(ApatosaurusEntity.class);
        this.setTimePeriod(TimePeriod.JURASSIC);
        this.setEggColorMale(5659467, 8032860);
        this.setEggColorFemale(0x31313F, 0x222238);
        this.setHealth(10.0, 80.0);
        this.setStrength(5.0, 20.0);
        this.setSpeed(0.2, 0.25);
        this.setMaximumAge(this.fromDays(80));
        this.setEyeHeight(0.5f, 3.59f);
        this.setSizeX(0.5f, 6.3f);
        this.setSizeY(0.6f, 6.6f);
        this.setStorage(54);
        this.setDiet(Diet.HERBIVORE.get());
        this.setBones("front_leg_bones", "hind_leg_bones", "neck_vertebrae", "pelvis", "ribcage", "shoulder", "skull", "tail_vertebrae", "tooth");
        this.setHeadCubeName("Head");
        this.setScale(1.32f, 0.1f);
        this.setBreeding(false, 4, 8, 70, false, true);
        this.setImprintable(true);
        this.setMaxHerdSize(6);
        this.setOffset(0.0f, 0.0f, 0.1f);
        String[][] recipe = new String[][]{{"", "", "", "", "skull"}, {"", "", "", "neck_vertebrae", "tooth"}, {"tail_vertebrae", "pelvis", "ribcage", "shoulder", ""}, {"", "hind_leg_bones", "hind_leg_bones", "front_leg_bones", "front_leg_bones"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207592_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

