/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.BrachiosaurusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class BrachiosaurusDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.22f;

    public BrachiosaurusDinosaur() {
        this.setName("Brachiosaurus");
        this.setScientificName("Brachiosaurus altithorax");
        this.setFamily("Brachiosauridae");
        this.setLocation("United States");
        this.setDinosaurType(Dinosaur.DinosaurType.NEUTRAL);
        this.setDinosaurClass(BrachiosaurusEntity.class);
        this.setDinosaurType(Dinosaur.DinosaurType.NEUTRAL);
        this.setTimePeriod(TimePeriod.JURASSIC);
        this.setEggColorMale(9540182, 7677980);
        this.setEggColorFemale(6442563, 8153950);
        this.setHealth(10.0, 150.0);
        this.setSpeed(0.16999999880790712, 0.22f);
        this.setStrength(5.0, 30.0);
        this.setMaximumAge(this.fromDays(85));
        this.setEyeHeight(1.0f, 3.4f);
        this.setSizeX(0.5f, 6.15f);
        this.setSizeY(1.1f, 6.65f);
        this.setDiet(Diet.HERBIVORE.get());
        this.setBones("front_leg_bones", "hind_leg_bones", "neck_vertebrae", "pelvis", "ribcage", "shoulder", "skull", "tail_vertebrae", "tooth");
        this.setHeadCubeName("head");
        this.setScale(1.75f, 0.1f);
        this.setOffset(0.0f, 0.0f, 1.0f);
        this.setAttackBias(1200.0);
        this.setPaleoPadScale(5.0f);
        this.setMaxHerdSize(15);
        this.setBreeding(false, 4, 8, 70, true, false);
        String[][] recipe = new String[][]{{"", "", "", "", "skull"}, {"", "", "", "neck_vertebrae", "tooth"}, {"tail_vertebrae", "pelvis", "ribcage", "shoulder", ""}, {"", "hind_leg_bones", "hind_leg_bones", "front_leg_bones", "front_leg_bones"}};
        this.setRecipe(recipe);
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207592_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
        this.enableSkeleton();
    }
}

