/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CompsognathusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class CompsognathusDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public CompsognathusDinosaur() {
        this.setName("Compsognathus");
        this.setScientificName("Compsognathus longipes");
        this.setFamily("Compsognathidae");
        this.setLocation("Germany");
        this.setDinosaurType(Dinosaur.DinosaurType.SCARED);
        this.setDinosaurClass(CompsognathusEntity.class);
        this.setTimePeriod(TimePeriod.JURASSIC);
        this.setEggColorMale(8093762, 4541243);
        this.setEggColorFemale(8221514, 4737597);
        this.setHealth(2.0, 4.0);
        this.setSpeed(0.3500000059604645, 0.4f);
        this.setStrength(1.0, 3.0);
        this.setMaximumAge(this.fromDays(20));
        this.setAttackBias(50.0);
        this.setEyeHeight(0.2f, 0.5f);
        this.setSizeX(0.1f, 0.3f);
        this.setSizeY(0.25f, 0.55f);
        this.setStorage(9);
        this.setDiet(Diet.CARNIVORE.get());
        this.setBones("arm_bones", "leg_bones", "neck_vertebrae", "pelvis", "ribcage", "shoulder", "skull", "tail_vertebrae", "teeth");
        this.setHeadCubeName("Head");
        this.setScale(0.2f, 0.04f);
        this.setOffset(0.0f, -3.0f, -0.8f);
        this.setBreeding(false, 2, 6, 15, false, true);
        this.setJumpHeight(2);
        this.setCanClimb(true);
        this.setImprintable(true);
        String[][] recipe = new String[][]{{"", "", "", "neck_vertebrae", "skull"}, {"tail_vertebrae", "pelvis", "ribcage", "shoulder", "teeth"}, {"leg_bones", "leg_bones", "", "", "arm_bones"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_207592_, BiomeTags.f_207607_, Tags.Biomes.IS_SANDY};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

