/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DeinotheriumEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class DeinotheriumDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.3f;

    public DeinotheriumDinosaur() {
        this.setName("Deinotherium");
        this.setScientificName("Deinotherium giganteum");
        this.setFamily("Deinotheriidae");
        this.setLocation("Africa");
        this.setDinosaurType(Dinosaur.DinosaurType.NEUTRAL);
        this.setDinosaurClass(DeinotheriumEntity.class);
        this.setTimePeriod(TimePeriod.PALEOGENE);
        this.setEggColorMale(6445908, 0x997969);
        this.setEggColorFemale(8815221, 13221038);
        this.setHealth(10.0, 40.0);
        this.setSpeed(0.25000001192092897, 0.3f);
        this.setStorage(27);
        this.setStrength(3.0, 15.0);
        this.setMaximumAge(this.fromDays(45));
        this.setEyeHeight(1.2f, 3.2f);
        this.setSizeX(1.25f, 3.0f);
        this.setSizeY(1.4f, 3.3f);
        this.setDiet(Diet.HERBIVORE.get());
        this.setBones("skull", "tooth", "front_leg_bones", "hind_leg_bones", "tusk", "neck_vertebrae", "pelvis", "ribcage", "shoulder", "tail_vertebrae");
        this.setHeadCubeName("Head");
        this.setScale(2.0f, 0.45f);
        this.setMammal(true);
        this.setBirthType(Dinosaur.BirthType.LIVE_BIRTH);
        this.shouldDefendOffspring();
        this.setAttackBias(400.0);
        this.setImprintable(true);
        this.setDefendOwner(true);
        this.setBreeding(true, 2, 4, 40, false, true);
        String[][] recipe = new String[][]{{"", "", "", "neck_vertebrae", "skull"}, {"tail_vertebrae", "pelvis", "ribcage", "tooth", "tusk"}, {"", "hind_leg_bones", "", "front_leg_bones", "shoulder"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{BiomeTags.f_207592_, Tags.Biomes.IS_CONIFEROUS, Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_207607_, Tags.Biomes.IS_SNOWY};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

