/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DilophosaurusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.entities.EntityUtils.SleepTime;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class DilophosaurusDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public DilophosaurusDinosaur() {
        this.setName("Dilophosaurus");
        this.setScientificName("Dilophosaurus wetherilli");
        this.setFamily("Dilophosauridae");
        this.setLocation("United States");
        this.setDinosaurClass(DilophosaurusEntity.class);
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setTimePeriod(TimePeriod.JURASSIC);
        this.setEggColorMale(7043124, 2764336);
        this.setEggColorFemale(6451502, 3154972);
        this.setHealth(10.0, 30.0);
        this.setSpeed(0.3500000059604645, 0.4f);
        this.setStrength(2.0, 6.0);
        this.setMaximumAge(this.fromDays(40));
        this.setEyeHeight(0.45f, 1.55f);
        this.setSizeX(0.4f, 1.2f);
        this.setSizeY(0.5f, 1.9f);
        this.setStorage(27);
        this.setDiet(Diet.CARNIVORE.get());
        this.setSleepTime(SleepTime.CREPUSCULAR);
        this.setBones("arm_bones", "leg_bones", "neck", "pelvis", "ribcage", "shoulder", "skull", "tail_vertebrae", "tooth");
        this.setHeadCubeName("Head");
        this.setScale(0.45f, 0.05f);
        this.setImprintable(true);
        this.setSkeletonScale(1.27f, 0.25f);
        this.setDefendOwner(true);
        this.setMaxHerdSize(10);
        this.setAttackBias(1200.0);
        this.setBreeding(false, 2, 4, 24, false, true);
        String[][] recipe = new String[][]{{"", "", "", "neck", "skull"}, {"tail_vertebrae", "pelvis", "ribcage", "shoulder", "tooth"}, {"leg_bones", "leg_bones", "", "", "arm_bones"}};
        this.setRecipe(recipe);
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_207592_, Tags.Biomes.IS_CONIFEROUS, BiomeTags.f_207607_, Tags.Biomes.IS_SANDY};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
        this.enableSkeleton();
    }
}

