/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.HyaenodonEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class HyaenodonDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public HyaenodonDinosaur() {
        this.setName("Hyaenodon");
        this.setScientificName("Hyaenodon leptorhynchus");
        this.setFamily("Hyaenodontidae");
        this.setLocation("Asia");
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setDinosaurClass(HyaenodonEntity.class);
        this.setTimePeriod(TimePeriod.PALEOGENE);
        this.setEggColorMale(0xA3A3A3, 0x191919);
        this.setEggColorFemale(7300690, 1052171);
        this.setHealth(10.0, 40.0);
        this.setSpeed(0.3500000059604645, 0.4f);
        this.setStorage(27);
        this.setStrength(1.0, 15.0);
        this.setMaximumAge(this.fromDays(45));
        this.setEyeHeight(0.35f, 1.7f);
        this.setSizeX(0.2f, 1.4f);
        this.setSizeY(0.4f, 1.8f);
        this.setDiet(Diet.CARNIVORE.get());
        this.setBones("skull", "tail_vertebrae", "front_leg_bones", "ribcage", "hind_leg_bones", "neck_vertebrae", "pelvis", "shoulder", "tooth");
        this.setHeadCubeName("Head");
        this.setScale(1.3f, 0.15f);
        this.setBirthType(Dinosaur.BirthType.LIVE_BIRTH);
        this.shouldDefendOffspring();
        this.setBreeding(true, 2, 4, 40, false, true);
        this.setAttackBias(600.0);
        this.setAttackSpeed(1.9);
        this.setImprintable(true);
        this.setDefendOwner(true);
        this.setMammal(true);
        String[][] recipe = new String[][]{{"tail_vertebrae", "pelvis", "ribcage", "neck_vertebrae", "skull"}, {"hind_leg_bones", "", "front_leg_bones", "shoulder", "tooth"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{BiomeTags.f_207592_, Tags.Biomes.IS_PLAINS};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

