/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MegalodonEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.entities.EntityUtils.SleepTime;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class MegalodonDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.45f;

    public MegalodonDinosaur() {
        this.setName("Megalodon");
        this.setScientificName("Otodus megalodon");
        this.setFamily("Otodontidae");
        this.setLocation("Worldwide");
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setDinosaurClass(MegalodonEntity.class);
        this.setTimePeriod(TimePeriod.NEOGENE);
        this.setEggColorMale(4606021, 13025725);
        this.setEggColorFemale(8487036, 12104623);
        this.setHealth(10.0, 90.0);
        this.setSpeed(0.34999998807907107, 0.45f);
        this.setStrength(10.0, 30.0);
        this.setMaximumAge(this.fromDays(50));
        this.setEyeHeight(0.3f, 2.0f);
        this.setSizeX(0.8f, 4.0f);
        this.setSizeY(0.8f, 4.0f);
        this.setMarineAnimal(true);
        this.setStorage(27);
        this.setPaleoPadScale(2.0f);
        this.setDiet(Diet.PCARNIVORE.get());
        this.setSleepTime(SleepTime.DIURNAL);
        this.setBirthType(Dinosaur.BirthType.LIVE_BIRTH);
        this.setBones("lower_jaw", "upper_jaw", "tooth");
        this.setHeadCubeName("Main head");
        this.setScale(1.05f, 0.15f);
        this.setAttackBias(420.0);
        this.setImprintable(false);
        this.setBreeding(true, 2, 4, 28, false, false);
        String[][] recipe = new String[][]{{"tooth", "tooth", "tooth", "tooth", "tooth"}, {"tooth", "", "upper_jaw", "", "tooth"}, {"tooth", "", "lower_jaw", "", "tooth"}, {"tooth", "", "", "", "tooth"}, {"tooth", "tooth", "tooth", "tooth", "tooth"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_WATER, BiomeTags.f_207603_, BiomeTags.f_207605_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

