/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.NigersaurusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class NigersaurusDinosaur
extends Dinosaur {
    public static final double SPEED = 0.25;

    public NigersaurusDinosaur() {
        this.setName("Nigersaurus");
        this.setScientificName("Nigersaurus taqueti");
        this.setFamily("Rebbachisauridae");
        this.setLocation("Niger, Africa");
        this.setDinosaurType(Dinosaur.DinosaurType.NEUTRAL);
        this.setDinosaurClass(NigersaurusEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(3883577, 5406799);
        this.setEggColorFemale(1780518, 16298016);
        this.setHealth(5.0, 40.0);
        this.setSpeed(0.2, 0.25);
        this.setStorage(52);
        this.setDiet(Diet.HERBIVORE.get());
        this.setStrength(5.0, 40.0);
        this.setMaximumAge(this.fromDays(95));
        this.setEyeHeight(0.45f, 1.95f);
        this.setSizeX(0.4f, 2.0f);
        this.setSizeY(0.5f, 1.9f);
        this.setBones("skull", "tooth", "front_leg_bones", "hind_leg_bones", "neck_vertebrae", "pelvis", "ribcage", "shoulder", "tail_vertebrae");
        this.setHeadCubeName("Head");
        this.setScale(0.45f, 0.1f);
        this.setPaleoPadScale(5.0f);
        this.shouldDefendOffspring();
        this.setAttackBias(1500.0);
        this.setBreeding(false, 4, 8, 80, false, true);
        String[][] recipe = new String[][]{{"", "", "", "", "skull"}, {"", "", "", "neck_vertebrae", "tooth"}, {"tail_vertebrae", "pelvis", "ribcage", "shoulder", ""}, {"", "hind_leg_bones", "hind_leg_bones", "front_leg_bones", "front_leg_bones"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207592_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

