/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.TitanisEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.entities.EntityUtils.SleepTime;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class TitanisDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public TitanisDinosaur() {
        this.setName("Titanis");
        this.setScientificName("Titanis walleri");
        this.setFamily("Phorusrhacidae");
        this.setLocation("United States");
        this.setDinosaurClass(TitanisEntity.class);
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setTimePeriod(TimePeriod.PALEOGENE);
        this.setEggColorMale(15065555, 5790093);
        this.setEggColorFemale(15065555, 8090210);
        this.setSpeed(0.3500000059604645, 0.4f);
        this.setAttackSpeed(1.95);
        this.setHealth(6.0, 30.0);
        this.setStrength(2.0, 15.0);
        this.setMaximumAge(this.fromDays(45));
        this.setEyeHeight(0.45f, 2.4f);
        this.setSizeX(0.5f, 2.3f);
        this.setSizeY(0.5f, 2.5f);
        this.setStorage(20);
        this.setDiet(Diet.CARNIVORE.get());
        this.setSleepTime(SleepTime.DIURNAL);
        this.setBones("skull", "leg_bones", "ribcage", "neck_vertebrae", "pelvis", "shoulder");
        this.setHeadCubeName("Head");
        this.setScale(1.35f, 0.2f);
        this.setImprintable(true);
        this.setDefendOwner(true);
        this.setMaxHerdSize(40);
        this.setAttackBias(600.0);
        this.setCanClimb(true);
        this.setBreeding(false, 2, 4, 30, false, true);
        this.setJumpHeight(3);
        String[][] recipe = new String[][]{{"", "pelvis", "ribcage", "neck_vertebrae", "skull"}, {"leg_bones", "", "leg_bones", "shoulder", ""}};
        this.setRecipe(recipe);
        this.doSkeletonCheck();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{BiomeTags.f_207592_, Tags.Biomes.IS_CONIFEROUS, Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_207607_, Tags.Biomes.IS_SNOWY, Tags.Biomes.IS_COLD};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }

    protected void doSkeletonCheck() {
        this.enableSkeleton();
    }
}

