/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.EntityUtils;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.util.GameRuleHandler;

public class MetabolismContainer {
    public static final int MAX_DIGESTION_AMOUNT = 3000;
    private final int maxEnergy;
    private final int maxWater;
    private int energy;
    private int digestingFood;
    private int water;
    private final DinosaurEntity dinosaur;

    public MetabolismContainer(DinosaurEntity dinosaur) {
        this.dinosaur = dinosaur;
        double health = Math.max(1.0, dinosaur.getDinosaur().getAdultHealth());
        this.maxEnergy = (int)Math.max(1.0, health / 10.0 * 24000.0);
        this.maxWater = (int)Math.max(1.0, health / 10.0 * 24000.0);
        this.energy = this.maxEnergy;
        this.water = this.maxWater;
    }

    public void update() {
        if (!this.dinosaur.m_21224_() && !this.dinosaur.isCarcass() && this.dinosaur.f_19853_.m_46469_().m_46207_(GameRuleHandler.DINO_METABOLISM)) {
            this.decreaseEnergy(1);
            this.decreaseWater(1);
            if (this.dinosaur.m_20071_()) {
                if (this.isThirsty()) {
                    this.dinosaur.setAnimation(EntityAnimation.DRINKING.get());
                }
                this.water = this.maxWater;
            }
            if (this.digestingFood > 0) {
                this.increaseEnergy(25);
                --this.digestingFood;
            }
        }
    }

    public int getWater() {
        return this.water;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getDigestingFood() {
        return this.digestingFood;
    }

    public int getMaxEnergy() {
        return this.maxEnergy;
    }

    public int getMaxWater() {
        return this.maxWater;
    }

    public void setWater(int water) {
        this.water = Math.max(0, Math.min(water, this.maxWater));
    }

    public void setEnergy(int energy) {
        this.energy = Math.max(0, Math.min(energy, this.maxEnergy));
    }

    public void decreaseEnergy(int amount) {
        this.setEnergy(this.energy - Math.max(0, amount));
        if (this.isStarving() && this.dinosaur.f_19797_ % 40 == 0) {
            this.dinosaur.m_6469_(DamageSource.f_19313_, 1.0f);
        }
    }

    public void decreaseWater(int amount) {
        this.setWater(this.water - Math.max(0, amount));
        if (this.isDehydrated() && this.dinosaur.f_19797_ % 40 == 0) {
            this.dinosaur.m_6469_(DamageSource.f_19313_, 1.0f);
        }
    }

    public void setDigestingFoodAmount(int digesting) {
        this.digestingFood = Math.min(Math.max(0, digesting), 3000);
    }

    public void increaseEnergy(int amount) {
        this.setEnergy(this.energy + Math.max(0, amount));
    }

    public void increaseWater(int amount) {
        this.setWater(this.water + Math.max(0, amount));
    }

    public void eat(int amount) {
        amount = Math.max(0, amount);
        this.increaseEnergy(amount / 10);
        this.setDigestingFoodAmount(this.digestingFood + amount);
    }

    public boolean isStarving() {
        return this.energy < 200 && this.digestingFood <= 50;
    }

    public boolean isDehydrated() {
        return this.water < 50;
    }

    public boolean isHungry() {
        double energyRatio = (double)this.energy / (double)this.maxEnergy;
        double effectiveDigesting = (double)this.digestingFood * Math.max(0.1, energyRatio) * 10.0;
        boolean belowTarget = (double)this.energy + effectiveDigesting < (double)this.maxEnergy * 0.8;
        boolean lowAbsolute = this.energy < 100;
        boolean roomToDigest = this.digestingFood + 500 < 3000;
        return (belowTarget || lowAbsolute) && roomToDigest;
    }

    public boolean isThirsty() {
        return (double)this.water < (double)this.maxWater * 0.5;
    }

    public void readFromNBT(CompoundTag nbt) {
        this.setWater(nbt.m_128451_("Water"));
        this.setEnergy(nbt.m_128451_("Energy"));
        this.setDigestingFoodAmount(nbt.m_128451_("DigestingFood"));
    }

    public void writeToNBT(CompoundTag nbt) {
        nbt.m_128405_("Water", this.water);
        nbt.m_128405_("Energy", this.energy);
        nbt.m_128405_("DigestingFood", this.digestingFood);
    }
}

