/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai;

import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;

public class AssistOwnerAI
extends Goal {
    private static final double MAX_DISTANCE_SQR = 2304.0;
    private final DinosaurEntity dino;
    private Player owner;
    private LivingEntity target;
    private int lastAttackedTs;
    private int lastHurtByTs;

    public AssistOwnerAI(DinosaurEntity dino) {
        this.dino = dino;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        if (this.dino.isCarcass() || !this.dino.m_6084_() || this.dino.isMovementBlocked()) {
            return false;
        }
        if (this.dino.getAgePercentage() <= 50) {
            return false;
        }
        if (this.dino.getOrder() != DinosaurEntity.Order.FOLLOW) {
            return false;
        }
        UUID id = this.dino.getOwner();
        if (id == null) {
            return false;
        }
        this.owner = this.dino.f_19853_.m_46003_(id);
        if (this.owner == null || this.owner.m_5833_()) {
            return false;
        }
        LivingEntity hurtBy = this.owner.m_142581_();
        LivingEntity attacked = this.owner.m_21214_();
        int hurtByTs = this.owner.m_21213_();
        int attackedTs = this.owner.m_21215_();
        LivingEntity pick = null;
        int pickTs = -1;
        if (hurtBy != null && hurtBy != this.dino && hurtBy.m_6084_()) {
            pick = hurtBy;
            pickTs = hurtByTs;
        }
        if (attacked != null && attacked != this.dino && attacked.m_6084_() && attackedTs > pickTs) {
            pick = attacked;
            pickTs = attackedTs;
        }
        if (pick == null) {
            return false;
        }
        this.target = pick;
        this.lastHurtByTs = hurtByTs;
        this.lastAttackedTs = attackedTs;
        return !(this.dino.m_20280_((Entity)this.target) > 2304.0);
    }

    public void m_8056_() {
        this.dino.m_6710_(this.target);
    }

    public boolean m_8045_() {
        if (this.dino.isCarcass() || !this.dino.m_6084_() || this.dino.isMovementBlocked()) {
            return false;
        }
        if (this.dino.getOrder() != DinosaurEntity.Order.FOLLOW) {
            return false;
        }
        if (this.owner == null || this.owner.m_5833_()) {
            return false;
        }
        return this.target != null && this.target.m_6084_() && this.dino.m_20280_((Entity)this.target) <= 2304.0;
    }

    public void m_8037_() {
        LivingEntity newHurtBy = this.owner.m_142581_();
        LivingEntity newAttacked = this.owner.m_21214_();
        int newHurtByTs = this.owner.m_21213_();
        int newAttackedTs = this.owner.m_21215_();
        LivingEntity best = this.target;
        int bestTs = Math.max(this.lastHurtByTs, this.lastAttackedTs);
        if (newHurtBy != null && newHurtBy.m_6084_() && newHurtBy != this.dino && newHurtByTs > bestTs) {
            best = newHurtBy;
            bestTs = newHurtByTs;
        }
        if (newAttacked != null && newAttacked.m_6084_() && newAttacked != this.dino && newAttackedTs > bestTs) {
            best = newAttacked;
            bestTs = newAttackedTs;
        }
        if (best != this.target) {
            this.target = best;
            this.dino.m_6710_(this.target);
            this.lastHurtByTs = newHurtByTs;
            this.lastAttackedTs = newAttackedTs;
        } else if (this.dino.m_5448_() != this.target) {
            this.dino.m_6710_(this.target);
        }
    }

    public void m_8041_() {
        this.dino.m_6710_(null);
        this.owner = null;
        this.target = null;
        this.lastAttackedTs = 0;
        this.lastHurtByTs = 0;
    }
}

