/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai.metabolism;

import java.util.EnumSet;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.EntityUtils.MetabolismContainer;
import net.vit.jurassicreborn.common.entities.ai.util.OnionTraverser;
import net.vit.jurassicreborn.common.items.Food.FoodHelper;

public class GrazeEntityAI
extends Goal {
    private static final int LOOK_RADIUS = 16;
    private static final int EAT_RADIUS_SQ = 36;
    private static final int GIVE_UP_TICKS = 400;
    private final DinosaurEntity dino;
    private Iterator<BlockPos> searchIter = null;
    private BlockPos target;
    private BlockPos moveTarget;
    private int giveUpCounter;

    public GrazeEntityAI(DinosaurEntity dino) {
        this.dino = dino;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.dino.m_21224_() || this.dino.isCarcass()) {
            return false;
        }
        if (this.dino.m_5448_() != null) {
            return false;
        }
        if (!this.dino.getMetabolism().isHungry()) {
            return false;
        }
        if (!this.dino.getMetabolism().isStarving() && this.dino.getClosestFeeder() != null) {
            return false;
        }
        if (this.moveTarget == null) {
            this.ensureSearchIterator();
            this.advanceSearch(64);
        }
        if (this.moveTarget != null) {
            double speed = this.dino.getMetabolism().isStarving() ? 1.2 : 0.7;
            this.dino.m_21573_().m_26519_((double)this.moveTarget.m_123341_() + 0.5, (double)this.moveTarget.m_123342_(), (double)this.moveTarget.m_123343_() + 0.5, speed);
            this.giveUpCounter = 400;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.dino.m_5448_() != null) {
            this.abort();
            return false;
        }
        if (this.target != null && this.dino.f_19853_.m_46859_(this.target)) {
            this.abort();
            return false;
        }
        return this.target != null;
    }

    public void m_8041_() {
        this.abort();
    }

    public void m_8037_() {
        Vec3 tgt;
        if (this.target == null) {
            return;
        }
        if (this.dino.m_5448_() != null) {
            this.abort();
            return;
        }
        Vec3 eye = this.dino.m_20299_(1.0f);
        if (eye.m_82557_(tgt = Vec3.m_82512_((Vec3i)this.target)) <= 36.0) {
            this.dino.m_21573_().m_26573_();
            this.dino.m_21563_().m_24950_(tgt.f_82479_, tgt.f_82480_, tgt.f_82481_, 30.0f, (float)this.dino.m_8132_());
            this.dino.setAnimation(EntityAnimation.EATING.get());
            BlockState state = this.dino.f_19853_.m_8055_(this.target);
            Item item = state.m_60734_().m_5456_();
            if (item != Items.f_41852_) {
                this.dino.f_19853_.m_46961_(this.target, false);
                MetabolismContainer meta = this.dino.getMetabolism();
                meta.eat(FoodHelper.getHealAmount(item));
                FoodHelper.applyEatEffects(this.dino, item);
                this.dino.m_5634_(10.0f);
            }
            this.abort();
            return;
        }
        if (this.moveTarget == null && this.searchIter != null) {
            this.advanceSearch(32);
        }
        if (--this.giveUpCounter <= 0) {
            this.abort();
        }
    }

    private void abort() {
        this.dino.m_21573_().m_26573_();
        this.target = null;
        this.moveTarget = null;
        this.searchIter = null;
        this.dino.setAnimation(EntityAnimation.IDLE.get());
    }

    private void ensureSearchIterator() {
        if (this.searchIter == null) {
            Vec3 eye = this.dino.m_20299_(1.0f);
            BlockPos origin = new BlockPos(eye.f_82479_, eye.f_82480_, eye.f_82481_);
            this.searchIter = new OnionTraverser(origin, 16).iterator();
        }
    }

    private void advanceSearch(int maxSteps) {
        if (this.searchIter == null) {
            return;
        }
        for (int i = 0; i < maxSteps && this.searchIter.hasNext(); ++i) {
            BlockPos stand;
            Item item;
            BlockState state;
            BlockPos pos = this.searchIter.next();
            if (!this.dino.f_19853_.m_46749_(pos) || (state = this.dino.f_19853_.m_8055_(pos)).m_60795_() || state.m_204336_(BlockTags.f_13035_) || state.m_60734_() instanceof LeavesBlock || (item = state.m_60734_().m_5456_()) == Items.f_41852_ || !FoodHelper.isEdible(this.dino, this.dino.getDinosaur().getDiet(), item) || (stand = this.lowestSolidBelow(pos)) == null) continue;
            this.target = pos;
            this.moveTarget = stand;
            return;
        }
        if (!this.searchIter.hasNext() && this.moveTarget == null) {
            this.searchIter = null;
        }
    }

    private BlockPos lowestSolidBelow(BlockPos pos) {
        BlockState s;
        BlockPos p = pos;
        for (int i = 0; i < 16 && ((s = this.dino.f_19853_.m_8055_(p)).m_60734_() instanceof LeavesBlock || s.m_60795_()) && (p = p.m_7495_()).m_123342_() > this.dino.f_19853_.m_141937_(); ++i) {
        }
        BlockState ground = this.dino.f_19853_.m_8055_(p);
        if (ground.m_60795_() || ground.m_60734_() instanceof LeavesBlock) {
            return null;
        }
        return p;
    }
}

