/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai.navigation;

import com.github.alexthe666.citadel.animation.Animation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;

public class DinosaurJumpHelper
extends JumpControl {
    private final DinosaurEntity entity;
    private boolean sounded;
    private boolean jumped;
    private float yaw;
    private double speed;
    private int jumpHeight;

    public DinosaurJumpHelper(DinosaurEntity entity) {
        super((Mob)entity);
        this.entity = entity;
    }

    public void m_24901_() {
        this.jump(1);
    }

    public void jump(int height) {
        this.f_24897_ = true;
        this.jumped = true;
        this.jumpHeight = Math.min(this.entity.getDinosaur().getJumpHeight(), height);
        this.yaw = this.entity.m_146908_();
        this.speed = this.entity.m_6113_();
        Animation animation = this.entity.getAnimation();
        if (this.jumpHeight > 1 && animation != EntityAnimation.PREPARE_LEAP.get() && animation != EntityAnimation.LEAP.get() && animation != EntityAnimation.LEAP_LAND.get()) {
            if (!this.entity.m_20069_() && !this.entity.inLava() && this.entity.m_20096_()) {
                this.entity.setAnimation(EntityAnimation.PREPARE_LEAP.get());
            }
            this.sounded = false;
        } else {
            this.sounded = true;
        }
    }

    public void m_8124_() {
        if (!this.sounded && this.jumpHeight > 1 && this.entity.getAnimation() == EntityAnimation.LEAP.get()) {
            this.entity.m_5496_(this.entity.getSoundForAnimation(EntityAnimation.ATTACKING.get()), this.entity.m_6121_(), this.entity.m_6100_());
            this.sounded = true;
        }
        if (this.f_24897_ && (this.jumpHeight <= 1 || this.entity.getAnimation() == EntityAnimation.LEAP.get())) {
            this.entity.m_6862_(this.f_24897_);
            this.entity.setJumpHeight(this.jumpHeight);
            this.f_24897_ = false;
            this.jumpHeight = 0;
        } else {
            if (this.jumped && (this.entity.getAnimation() == EntityAnimation.LEAP.get() || this.entity.getAnimation() == EntityAnimation.LEAP_LAND.get())) {
                this.entity.m_146922_(this.yaw);
                float forwardSpeed = (float)(this.speed * (double)0.2f);
                float yawRadians = this.entity.m_146908_() * ((float)Math.PI / 180);
                double impulseX = -Math.sin(yawRadians) * (double)forwardSpeed;
                double impulseZ = Math.cos(yawRadians) * (double)forwardSpeed;
                this.entity.m_20256_(this.entity.m_20184_().m_82520_(impulseX, 0.0, impulseZ));
            }
            if (this.entity.getAnimation() == EntityAnimation.LEAP_LAND.get()) {
                this.jumped = false;
                this.sounded = false;
            }
            this.entity.m_6862_(false);
            this.entity.setJumpHeight(0);
        }
    }
}

