/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.vehicle;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.client.input.VehicleKeyHandler;
import net.vit.jurassicreborn.client.render.RenderingHandler;
import net.vit.jurassicreborn.common.entities.ModEntities;
import net.vit.jurassicreborn.common.entities.vehicle.InterpValue;
import net.vit.jurassicreborn.common.entities.vehicle.VehicleEntity;
import net.vit.jurassicreborn.common.util.math.MutableVec3;
import net.vit.jurassicreborn.common.util.math.Vec3d;
import net.vit.jurassicreborn.common.util.particles.ModParticles;

public abstract class HelicopterEntity
extends VehicleEntity {
    private static final byte UPWARD = 16;
    private static final byte DOWNWARD = 32;
    private int rotationControl = 0;
    public float gearLift;
    public boolean shouldGearLift = true;
    private final InterpValue rotationYawInterp = new InterpValue(this, 4.0);
    public boolean isFlying;
    public final InterpValue interpRotationPitch = new InterpValue(this, 0.25);
    public final InterpValue interpRotationRoll = new InterpValue(this, 0.25);
    protected MutableVec3 direction;
    private static final int MAX_MOVEMENT_ROTATION = 15;
    private boolean shouldFallDamage;
    public double rotAmount = 0.0;
    private Vec3d prevInAirPos;
    private float damageAmount;
    private final BlockPos.MutableBlockPos mb = new BlockPos.MutableBlockPos();
    protected boolean lockOn;
    protected int blastHeight = 6;
    private static final float TAKEOFF_THRESHOLD_RATIO = 0.15f;
    private float currentEngineSpeed = 0.0f;
    protected float torque;
    protected float yawRotationAcceleration = 0.0f;
    private float shakingDirection = 0.0f;
    protected ResourceLocation warningSoundResource;
    private int warningDelay = 0;
    protected final int enginePower;
    protected final int engineSpeed;
    protected final int rotorLength;
    protected final int weight;
    private final float physicalWidth;
    protected final float physicalHeight;
    private final float physicalDepth;
    protected final float qualityGrade = 0.75f;
    protected boolean simpleControle;
    private boolean didDieOnce = false;

    public HelicopterEntity(Level worldIn, float widthIn, float heightIn, float depthIn, int enginePowerIn, int engineSpeedIn, int weightIn, int rotorLengthIn) {
        super((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.HELICOPTER.get()), worldIn);
        this.physicalWidth = widthIn;
        this.physicalHeight = heightIn;
        this.physicalDepth = depthIn;
        this.m_20011_(new AABB(0.0, 0.0, 0.0, (double)this.physicalWidth, (double)this.physicalHeight, (double)this.physicalDepth));
        this.enginePower = (int)((float)enginePowerIn * 735.5f);
        this.engineSpeed = engineSpeedIn;
        this.weight = weightIn;
        this.rotorLength = rotorLengthIn;
        this.torque = this.computeTorque();
        this.speedModifier = 1.5f;
        this.isFlying = false;
        this.direction = new MutableVec3(0.0, 1.0, 0.0);
        this.simpleControle = true;
        this.lockOn = true;
        this.warningSoundResource = new ResourceLocation("jurassicreborn", "helicopter_warning");
    }

    public boolean upward() {
        return this.getStateBit((byte)16);
    }

    public boolean downward() {
        return this.getStateBit((byte)32);
    }

    public void upward(boolean upward) {
        this.setStateBit((byte)16, upward);
    }

    public void downward(boolean downward) {
        this.setStateBit((byte)32, downward);
    }

    @Override
    public void startSound() {
        super.startSound();
    }

    protected boolean shouldStopUpdates() {
        return false;
    }

    @Override
    protected void doBlockCollisions() {
    }

    public boolean isController(Player e) {
        if (e == null || e.m_20202_() != this) {
            return false;
        }
        String seat = this.getIfExists(0, false);
        return !seat.isEmpty() && seat.equals(Integer.toString(e.m_142049_()));
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (!this.f_19853_.f_46443_) {
            if (player.m_20202_() == this) {
                return InteractionResult.CONSUME;
            }
            int seat = this.getSeatForEntity((Entity)player);
            if (seat == -1) {
                for (int i = 0; i < this.seats.length; ++i) {
                    if (!this.getIfExists(i, false).equals("")) continue;
                    seat = i;
                    break;
                }
            }
            if (seat != -1 && this.tryPutInSeat((Entity)player, seat, false)) {
                player.m_7998_((Entity)this, true);
            }
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handleControl() {
        if (this.isController((Player)Minecraft.m_91087_().f_91074_)) {
            if (this.m_20069_()) {
                this.upward(false);
                this.downward(false);
            } else {
                this.upward(VehicleKeyHandler.HELICOPTER_UP.m_90857_());
                this.downward(VehicleKeyHandler.HELICOPTER_DOWN.m_90857_());
                this.handleKeyEnableAutoPilot(VehicleKeyHandler.HELICOPTER_AUTOPILOT.m_90859_());
                this.handleKeyLock(VehicleKeyHandler.HELICOPTER_LOCK.m_90859_());
                this.rotateLeft(VehicleKeyHandler.HELICOPTER_ROTATE_LEFT.m_90857_());
                this.rotateRight(VehicleKeyHandler.HELICOPTER_ROTATE_RIGHT.m_90857_());
            }
            super.handleControl();
        }
        if (this.m_20363_((Entity)Minecraft.m_91087_().f_91074_)) {
            this.increaseThirdPersonViewDistance(VehicleKeyHandler.HELICOPTER_THIRD_PERSON_VIEW_ZOOM_OUT.m_90857_());
            this.decreaseThirdPersonViewDistance(VehicleKeyHandler.HELICOPTER_THIRD_PERSON_VIEW_ZOOM_IN.m_90857_());
        }
    }

    public void fall(float distance, float damageMultiplier) {
        float tmp;
        float damage;
        if (!this.f_19853_.f_46443_ && !this.isFlying && (damage = (float)Mth.m_14167_((float)((distance - 3.0f) * damageMultiplier))) > 0.0f) {
            this.setHealth(this.getHealth() - damage * 1.25f);
            this.checkAndHandleDeath();
        }
        if (this.f_19853_.f_46443_ && !this.isFlying && (damage = (float)Mth.m_14167_((float)((distance - 3.0f) * damageMultiplier))) > 0.0f && (tmp = this.getHealth() - damage * 1.25f) <= 0.0f) {
            this.playHelicopterExplosion();
        }
    }

    @Override
    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        if (this.f_19853_.f_46443_) {
            this.resetThirdPersonViewDistance();
        }
    }

    @Override
    public void m_8119_() {
        if (this.f_19853_.f_46443_) {
            this.isFlying = this.m_20068_();
        }
        super.m_8119_();
        if (!this.m_20069_()) {
            float dist = this.getDistanceToGround();
            if (this.f_19853_.f_46443_) {
                for (int i = 0; i < this.seats.length; ++i) {
                    Entity e = this.getEntityInSeat(i);
                    if (e == null) continue;
                    e.f_19789_ = 0.0f;
                }
            }
            if (this.forward() && this.isFlying) {
                this.pitch -= this.computeThrottleUpDown() / 2.0f;
            } else if (this.backward() && this.isFlying) {
                this.pitch += this.computeThrottleUpDown() / 2.0f;
            }
            if (this.left() && !this.right() && this.isFlying) {
                this.roll -= this.computeThrottleUpDown();
            } else if (this.right() && !this.left() && this.isFlying) {
                this.roll += this.computeThrottleUpDown();
            }
            if (this.rotateLeft() && !this.left() && !this.right() && this.isFlying && dist > 0.1f && this.getCurrentEngineSpeed() > 10.0f) {
                this.yawRotationAcceleration += 0.08f;
            } else if (this.rotateRight() && !this.left() && !this.right() && this.isFlying && dist > 0.1f && this.getCurrentEngineSpeed() > 10.0f) {
                this.yawRotationAcceleration -= 0.08f;
            }
            if (this.pitch > 180.0f) {
                this.pitch = -180.0f + (this.pitch - 180.0f);
            } else if (this.pitch < -180.0f) {
                this.pitch += 360.0f;
            }
            float maxRot = this.computeMaxMovementRotation(dist);
            this.pitch = Mth.m_14036_((float)this.pitch, (float)(-maxRot), (float)maxRot);
            this.roll = Mth.m_14036_((float)this.roll, (float)(-maxRot), (float)maxRot);
            if (!this.isLowHealth()) {
                float maxYawAccel = this.computeThrottleUpDown() * 2.0f;
                this.yawRotationAcceleration = Mth.m_14036_((float)this.yawRotationAcceleration, (float)(-maxYawAccel), (float)maxYawAccel);
            }
            if (dist <= 0.1f) {
                this.yawRotationAcceleration = 0.0f;
            }
            float requiredSpeedForHovering = this.computeRequiredEngineSpeedForHover();
            this.updateAutopilot(requiredSpeedForHovering, dist);
            this.updateHelicopterCrash(dist);
            this.m_146922_(this.m_146908_() + this.yawRotationAcceleration);
            this.rotationYawInterp.reset((double)this.m_146908_() - 180.0);
            this.interpRotationPitch.setTarget(this.direction.zCoord * -30.0);
            this.interpRotationRoll.setTarget(this.direction.xCoord * 20.0);
            if (this.m_6688_() != null && !this.isLowHealth()) {
                if (this.upward()) {
                    this.changeCurrentEngineSpeed(this.computeThrottleUpDown());
                    if (!this.isFlying && this.getCurrentEngineSpeed() >= (float)this.engineSpeed * 0.15f) {
                        this.setFlying();
                    }
                } else if (this.downward() && this.isFlying) {
                    this.shouldFallDamage = false;
                    this.changeCurrentEngineSpeed(-this.computeThrottleUpDown());
                } else if (!this.isFlying) {
                    this.m_20242_(false);
                    for (int i = 0; i < this.seats.length; ++i) {
                        Entity e = this.getEntityInSeat(i);
                        if (e == null) continue;
                        e.m_20242_(false);
                    }
                    if (this.simpleControle && this.getCurrentEngineSpeed() > 0.0f) {
                        this.changeCurrentEngineSpeed(-1.0f);
                    }
                }
                this.updateHelicopterTakeoffShaking(dist);
            } else if (this.getCurrentEngineSpeed() > 0.0f) {
                this.changeCurrentEngineSpeed(-1.0f);
            }
            if (this.f_19861_) {
                boolean wasFlying = this.isFlying;
                this.isFlying = false;
                if (wasFlying && this.shouldCrashOnLanding()) {
                    if (!this.f_19853_.f_46443_) {
                        this.setHealth(0.0f);
                        this.checkAndHandleDeath();
                    } else {
                        this.playHelicopterExplosion();
                    }
                }
                this.lockOn = true;
                this.pitch = 0.0f;
                this.roll = 0.0f;
                this.yawRotationAcceleration = 0.0f;
            }
            if (this.f_19853_.f_46443_) {
                this.gearLift = !this.shouldGearLift ? (this.gearLift += 0.02f) : (this.gearLift -= 0.02f);
                boolean bl = this.shouldGearLift = !(dist < 10.0f);
                if (this.gearLift < -0.5f) {
                    this.gearLift = -0.5f;
                }
                if (this.gearLift > 0.0f) {
                    this.gearLift = 0.0f;
                }
            }
            if (this.m_6688_() == null) {
                this.m_20242_(false);
            }
            if (this.f_19861_ && this.shouldFallDamage) {
                this.damageAmount = (float)this.prevInAirPos.y - (float)this.getPositionVector().y;
                this.setHealth(this.getHealth() - (float)Math.floor(this.damageAmount / 3.0f));
                this.shouldFallDamage = false;
                this.checkAndHandleDeath();
            }
            this.rotAmount += (double)this.getCurrentEngineSpeed() * 0.012566370614359173;
            if (this.getCurrentEngineSpeed() >= 1.0f && !this.isRotorAreaFree()) {
                this.setHealth(this.getHealth() - this.getCurrentEngineSpeed() / (float)this.engineSpeed * 2.0f);
                if (this.getHealth() <= 0.0f) {
                    if (!this.f_19853_.f_46443_) {
                        this.checkAndHandleDeath();
                    } else {
                        this.playHelicopterExplosion();
                    }
                }
            }
        } else {
            this.m_20242_(false);
            this.wheelRotateAmount = 0.0f;
            this.setCurrentEngineSpeed(this.getCurrentEngineSpeed() / 8.0f);
        }
        if (this.f_19853_.f_46443_) {
            this.spawnHoveringParticle();
            this.spawnEngineRunningParticle();
            this.spawnCrashingParticle();
            this.playWarningSound();
        }
        this.blastItems();
        this.checkAndHandleDeath();
    }

    @Override
    protected void applyMovement() {
        float surfaceFront = this.physicalWidth * this.physicalHeight;
        float surfaceTop = this.physicalWidth * this.physicalDepth;
        Vec3 delta = this.m_20184_();
        double vx = delta.f_82479_;
        double vy = delta.f_82480_;
        double vz = delta.f_82481_;
        float horizontalSpeed = (float)Math.abs(Math.sqrt(vx * vx + vz * vz) * 20.0);
        float verticalSpeed = (float)Math.abs(vy * 20.0);
        float flowResistanceFront = (float)((double)(2.0f * surfaceFront * 0.5f * 1.2f) * Math.pow(horizontalSpeed, 2.0));
        float flowResistanceTop = (float)((double)(2.0f * surfaceTop * 0.5f * 1.2f) * Math.pow(verticalSpeed, 2.0));
        float horizontalThrust = this.computeHorizontalForceFrontBack() / (float)this.weight / 20.0f;
        float verticalThrust = (float)(((double)(this.computeVerticalForce() / (float)this.weight) - 9.81) / 20.0);
        float moveAmount = horizontalThrust;
        moveAmount *= Math.abs((this.roll <= 45.0f ? this.roll / 45.0f : 2.0f - this.roll / 45.0f) * 2.0f * (this.pitch <= 90.0f ? this.pitch / 90.0f : 2.0f - this.pitch / 90.0f));
        double newY = vy + (double)verticalThrust - (double)(flowResistanceTop / (float)this.weight / 20.0f);
        if (this.roll > 0.0f && this.roll < 90.0f && this.pitch != 0.0f) {
            this.rotationDelta -= 20.0f * moveAmount;
        } else if (this.roll < 0.0f && this.roll > -90.0f && this.pitch != 0.0f) {
            this.rotationDelta += 20.0f * moveAmount;
        }
        this.rotationDelta = Mth.m_14036_((float)this.rotationDelta, (float)-3.0f, (float)3.0f);
        float yawRad = this.m_146908_() * ((float)Math.PI / 180);
        double newZ = vz - Math.cos(yawRad) * (double)horizontalThrust + Math.cos((this.m_146908_() - 90.0f) * ((float)Math.PI / 180)) * (double)this.computeHorizontalForceLeftRight() / (double)this.weight / 20.0;
        double newX = vx - Math.sin(-yawRad) * (double)horizontalThrust + Math.sin(-(this.m_146908_() - 90.0f) * ((float)Math.PI / 180)) * (double)this.computeHorizontalForceLeftRight() / (double)this.weight / 20.0;
        double drag = 0.04;
        newX -= vx * 0.04;
        newZ -= vz * 0.04;
        newY -= vy * 0.04;
        double max = 0.8;
        newX = Mth.m_14008_((double)newX, (double)(-max), (double)max);
        newY = Mth.m_14008_((double)newY, (double)(-max), (double)max);
        newZ = Mth.m_14008_((double)newZ, (double)(-max), (double)max);
        this.m_20334_(newX, newY, newZ);
        this.rotationDelta *= 0.85f;
        this.m_146922_(this.m_146908_() + this.rotationDelta);
    }

    private void updateHelicopterCrash(float dist) {
        if (this.isLowHealth() && this.isFlying && dist > 1.5f) {
            float targetRoll;
            float healthRatio = this.getHealth() / 40.0f;
            float instability = (1.0f - healthRatio) * 0.5f;
            this.yawRotationAcceleration += (float)((Math.random() - 0.5) * (double)instability * 1.5);
            this.yawRotationAcceleration = Mth.m_14036_((float)this.yawRotationAcceleration, (float)-7.0f, (float)7.0f);
            Vec3 deltaCrash = this.m_20184_();
            float driftAmount = instability * 0.03f;
            deltaCrash = deltaCrash.m_82520_(Math.sin(Math.toRadians(this.m_146908_())) * (double)driftAmount, 0.0, Math.cos(Math.toRadians(this.m_146908_())) * (double)driftAmount);
            this.m_20256_(deltaCrash);
            this.changeCurrentEngineSpeed(-0.5f * instability);
            float targetPitch = 15.0f + instability * 25.0f;
            if (this.pitch < targetPitch) {
                this.pitch += 0.15f * instability;
            }
            if (Math.abs(this.roll - (targetRoll = (float)(Math.sin((double)this.f_19797_ * 0.1) * 30.0 * (double)instability))) > 1.0f) {
                this.roll += (targetRoll - this.roll) * 0.05f;
            }
        }
    }

    private void handleDeath() {
        if (this.f_19853_.f_46443_ || this.didDieOnce || this.m_146910_()) {
            return;
        }
        this.didDieOnce = true;
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.dropItems();
        }
        this.m_146870_();
    }

    private void checkAndHandleDeath() {
        if (!this.f_19853_.f_46443_ && this.getHealth() <= 0.0f) {
            this.handleDeath();
        }
    }

    private void updateAutopilot(float requiredSpeedForHovering, float dist) {
        boolean hasVerticalInput;
        if (!this.simpleControle || !this.isFlying || this.m_6688_() == null || this.isLowHealth()) {
            return;
        }
        boolean hasHorizontalInput = this.forward() || this.backward() || this.left() || this.right();
        boolean bl = hasVerticalInput = this.upward() || this.downward();
        if (!hasHorizontalInput && this.lockOn) {
            this.pitch = Math.abs(this.pitch) < 0.6f ? 0.0f : this.pitch * 0.94f;
            float f = this.roll = Math.abs(this.roll) < 0.6f ? 0.0f : this.roll * 0.94f;
        }
        if (dist > 0.1f && this.getCurrentEngineSpeed() > 10.0f) {
            float f = this.yawRotationAcceleration = Math.abs(this.yawRotationAcceleration) < 0.03f ? 0.0f : this.yawRotationAcceleration * 0.9f;
        }
        if (!hasVerticalInput) {
            float current = this.getCurrentEngineSpeed();
            float vy = (float)this.m_20184_().f_82480_;
            float kP = 0.25f;
            float kV = 40.0f;
            float target = requiredSpeedForHovering - 40.0f * vy;
            float delta = ((target = Mth.m_14036_((float)target, (float)0.0f, (float)this.engineSpeed)) - current) * 0.25f;
            if (Math.abs(delta) < 0.05f) {
                delta = 0.0f;
            }
            this.changeCurrentEngineSpeed(delta);
        }
    }

    protected boolean isLowHealth() {
        return this.getHealth() <= 2.0f;
    }

    private void updateHelicopterTakeoffShaking(float dist) {
    }

    protected void updateShakingRotation() {
        this.roll += this.shakingDirection;
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    @Override
    public float getSoundVolume() {
        return this.getCurrentEngineSpeed() > 0.0f ? (Math.abs(this.getCurrentEngineSpeed() / 150.0f) + 0.001f) / (this.engineSound == null || this.engineSound.m_7801_() ? 2.0f : 4.0f) : (Math.abs(this.wheelRotateAmount) + 0.001f) / (this.engineSound == null || this.engineSound.m_7801_() ? 2.0f : 4.0f);
    }

    @Nonnull
    public Direction getAdjustedHorizontalFacing() {
        return Direction.m_122364_((double)this.m_146908_());
    }

    @Override
    public void m_7332_(Entity passenger) {
        if (this.m_20363_(passenger)) {
            Vec3d pos;
            VehicleEntity.Seat seat = null;
            if (this.getSeatForEntity(passenger) != -1) {
                seat = this.seats[this.getSeatForEntity(passenger)];
            }
            if (seat == null) {
                pos = new Vec3d(this.m_20185_(), this.m_20186_() + (double)this.physicalHeight, this.m_20189_());
            } else {
                Vec3 seatPos = seat.getPos(this);
                pos = new Vec3d(seatPos.f_82479_, seatPos.f_82480_, seatPos.f_82481_);
            }
            passenger.m_6034_(pos.x, pos.y + this.interpRotationPitch.getCurrent() / 75.0, pos.z);
            passenger.m_146922_(passenger.m_146908_() + this.rotationDelta);
            passenger.m_5616_(passenger.m_6080_() + this.rotationDelta);
            if (passenger instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)passenger;
                living.f_20883_ += (living.m_146908_() - living.f_20883_) * 0.6f;
            }
        }
    }

    private void playHelicopterExplosion() {
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.1, 0.1, 0.1);
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.NEUTRAL, 4.0f, (1.0f + (this.f_19853_.f_46441_.nextFloat() - this.f_19853_.f_46441_.nextFloat()) * 0.2f) * 0.7f);
    }

    private float computeMaxMovementRotation(float dist) {
        return dist <= 3.0f ? dist / 3.0f * (float)(this.lockOn ? 15 : 90) : (this.lockOn ? 15.0f : 180.0f);
    }

    public float getDistanceToGround() {
        boolean found = false;
        float dist = -1.0f;
        this.mb.m_122190_((Vec3i)this.m_142538_());
        while (!found && this.m_20186_() >= 0.0 && this.mb.m_123342_() >= 0) {
            if (this.f_19853_.m_46859_((BlockPos)this.mb)) {
                this.mb.m_122184_(0, -1, 0);
                continue;
            }
            found = true;
            dist = (float)(this.m_20186_() - (double)this.mb.m_123342_() - 1.0);
        }
        return dist;
    }

    protected BlockState getGroundBlock() {
        boolean found = false;
        BlockState groundBlock = null;
        this.mb.m_122190_((Vec3i)this.m_142538_());
        while (!found && this.m_20186_() >= 0.0 && this.mb.m_123342_() >= 0) {
            if (this.f_19853_.m_46859_((BlockPos)this.mb)) {
                this.mb.m_122184_(0, -1, 0);
                continue;
            }
            found = true;
            groundBlock = this.f_19853_.m_8055_((BlockPos)this.mb);
        }
        return groundBlock;
    }

    protected void updateHeal() {
    }

    @OnlyIn(value=Dist.CLIENT)
    private void increaseThirdPersonViewDistance(boolean shouldIncrease) {
        if (shouldIncrease) {
            RenderingHandler.INSTANCE.setThirdPersonViewDistance(RenderingHandler.INSTANCE.getThirdPersonViewDistance() + 1.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void decreaseThirdPersonViewDistance(boolean shouldDecrease) {
        if (shouldDecrease) {
            RenderingHandler.INSTANCE.setThirdPersonViewDistance(RenderingHandler.INSTANCE.getThirdPersonViewDistance() - 1.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void resetThirdPersonViewDistance() {
        RenderingHandler.INSTANCE.resetThirdPersonViewDistance();
    }

    public void setDead() {
        if (this.f_19853_.f_46443_) {
            this.playHelicopterExplosion();
        }
        super.m_146870_();
    }

    public float getCollisionBorderSize() {
        return 2.25f;
    }

    private boolean isRotorAreaFree() {
        boolean isFree = true;
        for (int x = -this.rotorLength; x < this.rotorLength && isFree; ++x) {
            for (int z = -this.rotorLength; z < this.rotorLength && isFree; ++z) {
                if (this.f_19853_.m_8055_(new BlockPos(this.m_20185_() + (double)x, this.m_20186_() + (double)this.physicalHeight, this.m_20189_() + (double)z)).m_60795_()) continue;
                isFree = false;
            }
        }
        return isFree;
    }

    protected Vec3d getPositionVector() {
        return new Vec3d(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    protected void setFlying() {
        this.isFlying = true;
        this.shouldFallDamage = true;
        this.prevInAirPos = this.getPositionVector();
        this.m_20242_(true);
        for (int i = 0; i < this.seats.length; ++i) {
            Entity e = this.getEntityInSeat(i);
            if (e == null) continue;
            e.m_20242_(false);
        }
    }

    public int getPositionLightFrequency() {
        return 30 - (int)(this.getCurrentEngineSpeed() / (float)this.engineSpeed * 20.0f);
    }

    protected void blastItems() {
        float dist = this.getDistanceToGround();
        if (dist >= 0.0f) {
            List items = this.f_19853_.m_45976_(Entity.class, new AABB(this.m_20185_() - (double)(this.rotorLength * 2), this.m_20186_() - (double)dist - 1.0, this.m_20189_() - (double)(this.rotorLength * 2), this.m_20185_() + (double)(this.rotorLength * 2), this.m_20186_() + 1.0, this.m_20189_() + (double)(this.rotorLength * 2)));
            for (Entity item : items) {
                float itemDist = item.m_20270_((Entity)this);
                if (!(itemDist <= (float)(this.rotorLength * 2)) || !((double)item.m_20205_() <= 0.55)) continue;
                float moveAmount = (float)((double)((1.0f - item.m_20270_((Entity)this) / (float)(this.rotorLength * 2)) * (1.0f - dist / (float)this.blastHeight)) * (1.0 / Math.pow(this.engineSpeed, 3.0) * Math.pow(this.getCurrentEngineSpeed(), 3.0)));
                float x = (float)((item.m_20185_() - this.m_20185_()) / (double)itemDist);
                float z = (float)((item.m_20189_() - this.m_20189_()) / (double)itemDist);
                item.m_5997_((double)(x * moveAmount), 0.0, (double)(z * moveAmount));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void spawnHoveringParticle() {
        float dist = this.getDistanceToGround();
        BlockState groundBlock = this.getGroundBlock();
        if (groundBlock == null) {
            return;
        }
        if (dist <= (float)this.blastHeight && dist >= 0.0f) {
            for (int i = 0; i < 360; ++i) {
                double d = Math.random() * 100.0;
                float f = 1.0f - dist / (float)this.blastHeight;
                int n = groundBlock.m_60734_().equals(Blocks.f_49990_) ? 80 : 20;
                if (!(d < (double)(f * (float)n) * (1.0 / Math.pow(this.engineSpeed, 3.0) * Math.pow(this.getCurrentEngineSpeed(), 3.0) * 1.0))) continue;
                float x = (float)(Math.cos(Math.toRadians(i)) * (double)((float)this.rotorLength / 1.8f) * (Math.random() * 0.2 + 1.0));
                float y = (float)(this.m_20186_() - (double)dist);
                float z = (float)(Math.sin(Math.toRadians(i)) * (double)((float)this.rotorLength / 1.8f) * (Math.random() * 0.2 + 1.0));
                if (groundBlock.m_60734_().equals(Blocks.f_49990_)) {
                    this.f_19853_.m_7106_((ParticleOptions)ModParticles.WASHING_DROPLET.get(), this.m_20185_() + (double)x, (double)(y + 0.5f), this.m_20189_() + (double)z, (double)(x / 5.0f), (double)0.001f, (double)(z / 5.0f));
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() + (double)x, (double)(y + 0.5f), this.m_20189_() + (double)z, (double)(x / 5.0f), (double)0.001f, (double)(z / 5.0f));
                    continue;
                }
                if (groundBlock.m_60767_().equals(Material.f_76307_)) continue;
                if (this.isBlockDusty(groundBlock.m_60734_())) {
                    double d2 = Math.random();
                    double d3 = this.f_19853_.m_46471_() ? 0.1 : 0.4;
                    if (d2 < d3) {
                        this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, groundBlock), this.m_20185_() + (double)x, (double)y + 0.1, this.m_20189_() + (double)z, (double)(x / 5.0f), (double)0.001f + Math.random() * (this.f_19853_.m_46471_() ? 0.0 : 0.5), (double)(z / 5.0f));
                    }
                }
                this.f_19853_.m_7106_((ParticleOptions)ModParticles.HELICOPTER_GROUND.get(), this.m_20185_() + (double)x, (double)y, this.m_20189_() + (double)z, (double)(x / 5.0f), (double)0.001f, (double)(z / 5.0f));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void spawnEngineRunningParticle() {
        float[] offsetBack = this.computeEngineOutletPosition(0.675f, -0.675f, 2.1f, 3.0625f);
        float[] directionBack1 = this.computeEngineExhaustParticleDirection(15.0f);
        float[] directionBack2 = this.computeEngineExhaustParticleDirection(-15.0f);
        for (int i = 0; i < 5; ++i) {
            if (!(Math.random() < (double)(this.getCurrentEngineSpeed() / (float)this.engineSpeed))) continue;
            this.f_19853_.m_7106_((ParticleOptions)ModParticles.HELICOPTER_ENGINE.get(), this.m_20185_() + (double)offsetBack[0] + Math.random() * 0.3, this.m_20186_() + (double)offsetBack[2] + Math.random() * 0.3, this.m_20189_() - (double)offsetBack[4] + Math.random() * 0.3, (double)(directionBack1[0] * (this.getCurrentEngineSpeed() * 3.0f / (float)this.engineSpeed)), (double)0.001f, (double)(directionBack1[2] * (this.getCurrentEngineSpeed() * 3.0f / (float)this.engineSpeed)));
            this.f_19853_.m_7106_((ParticleOptions)ModParticles.HELICOPTER_ENGINE.get(), this.m_20185_() + (double)offsetBack[1] + Math.random() * 0.3, this.m_20186_() + (double)offsetBack[3] + Math.random() * 0.3, this.m_20189_() - (double)offsetBack[5] + Math.random() * 0.3, (double)(directionBack2[0] * (this.getCurrentEngineSpeed() * 3.0f / (float)this.engineSpeed)), (double)0.001f, (double)(directionBack2[2] * (this.getCurrentEngineSpeed() * 3.0f / (float)this.engineSpeed)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void spawnCrashingParticle() {
        if (Math.random() < (double)(-(this.getHealth() * 1.6f - 40.0f) / 40.0f)) {
            float[] offsetFront = this.computeEngineOutletPosition(0.675f, -0.675f, 2.1f, 0.9375f);
            float[] offsetBack = this.computeEngineOutletPosition(0.675f, -0.675f, 2.1f, 3.0625f);
            float[] directionFront1 = this.computeEngineFrontSmokeParticleDirection(-20.0f);
            float[] directionFront2 = this.computeEngineFrontSmokeParticleDirection(20.0f);
            float[] directionBack = this.computeEngineExhaustParticleDirection(0.0f);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + (double)offsetBack[0], this.m_20186_() + (double)offsetBack[2], this.m_20189_() - (double)offsetBack[4], (double)directionBack[0], (double)directionBack[1], (double)directionBack[2]);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + (double)offsetBack[1], this.m_20186_() + (double)offsetBack[3], this.m_20189_() - (double)offsetBack[5], (double)directionBack[0], (double)directionBack[1], (double)directionBack[2]);
            if (this.m_20069_() && (double)this.f_19853_.m_46865_(this.m_142538_()).m_5885_(Heightmap.Types.MOTION_BLOCKING, this.m_142538_().m_123341_(), this.m_142538_().m_123343_()) - this.m_20186_() > 2.0) {
                if (Math.random() < (double)(1.0f - (this.getHealth() * 2.0f - 40.0f) / 40.0f)) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() + (double)offsetBack[0], this.m_20186_() + (double)offsetBack[2], this.m_20189_() - (double)offsetBack[4], 0.0, 0.0, 0.0);
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() + (double)offsetBack[1], this.m_20186_() + (double)offsetBack[3], this.m_20189_() - (double)offsetBack[5], 0.0, 0.0, 0.0);
                }
                if (Math.random() < (double)(1.0f - this.getCurrentEngineSpeed() * 1.6f / (float)this.engineSpeed)) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + (double)offsetFront[0], this.m_20186_() + (double)offsetFront[2], this.m_20189_() - (double)offsetFront[4], (double)directionFront1[0] * 0.5, (double)directionFront1[1] * 0.5, (double)directionFront1[2] * 0.5);
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + (double)offsetFront[1], this.m_20186_() + (double)offsetFront[3], this.m_20189_() - (double)offsetFront[5], (double)directionFront2[0] * 0.5, (double)directionFront2[1] * 0.5, (double)directionFront2[2] * 0.5);
                }
            } else {
                if (Math.random() < (double)(1.0f - (this.getHealth() * 2.0f - 40.0f) / 40.0f)) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + (double)offsetBack[0], this.m_20186_() + (double)offsetBack[2], this.m_20189_() - (double)offsetBack[4], (double)directionBack[0], (double)directionBack[1], (double)directionBack[2]);
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + (double)offsetBack[1], this.m_20186_() + (double)offsetBack[3], this.m_20189_() - (double)offsetBack[5], (double)directionBack[0], (double)directionBack[1], (double)directionBack[2]);
                }
                if (Math.random() < (double)(1.0f - this.getCurrentEngineSpeed() * 1.6f / (float)this.engineSpeed)) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + (double)offsetFront[0], this.m_20186_() + (double)offsetFront[2], this.m_20189_() - (double)offsetFront[4], (double)directionFront1[0], (double)directionFront1[1], (double)directionFront1[2]);
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + (double)offsetFront[1], this.m_20186_() + (double)offsetFront[3], this.m_20189_() - (double)offsetFront[5], (double)directionFront2[0], (double)directionFront2[1], (double)directionFront2[2]);
                }
            }
        }
    }

    protected float[] computeEngineOutletPosition(float xPos1, float xPos2, float yPos, float zPos) {
        float radiantRotationYaw = (float)Math.toRadians(this.m_146908_());
        float radiantPitch = (float)Math.toRadians(this.pitch);
        float radiantRoll = (float)Math.toRadians(this.roll);
        float[] offsets = new float[6];
        offsets[2] = yPos;
        offsets[3] = yPos;
        offsets[4] = zPos;
        offsets[5] = zPos;
        offsets[0] = xPos1;
        offsets[1] = xPos2;
        offsets[2] = (float)(Math.cos(-radiantPitch) * (double)yPos - Math.sin(-radiantPitch) * (double)zPos);
        offsets[3] = (float)(Math.cos(-radiantPitch) * (double)yPos - Math.sin(-radiantPitch) * (double)zPos);
        offsets[4] = (float)(Math.sin(-radiantPitch) * (double)yPos + Math.cos(-radiantPitch) * (double)zPos);
        offsets[5] = (float)(Math.sin(-radiantPitch) * (double)yPos + Math.cos(-radiantPitch) * (double)zPos);
        float[] tmpOffsets = (float[])offsets.clone();
        offsets[0] = (float)(Math.cos(-radiantRoll) * (double)tmpOffsets[0] - Math.sin(-radiantRoll) * (double)tmpOffsets[2]);
        offsets[1] = (float)(Math.cos(-radiantRoll) * (double)tmpOffsets[1] - Math.sin(-radiantRoll) * (double)tmpOffsets[3]);
        offsets[2] = (float)(Math.sin(-radiantRoll) * (double)tmpOffsets[0] + Math.cos(-radiantRoll) * (double)tmpOffsets[2]);
        offsets[3] = (float)(Math.sin(-radiantRoll) * (double)tmpOffsets[1] + Math.cos(-radiantRoll) * (double)tmpOffsets[3]);
        tmpOffsets = (float[])offsets.clone();
        offsets[0] = (float)(Math.cos(radiantRotationYaw) * (double)tmpOffsets[0] + Math.sin(radiantRotationYaw) * (double)tmpOffsets[4]);
        offsets[1] = (float)(Math.cos(radiantRotationYaw) * (double)tmpOffsets[1] + Math.sin(radiantRotationYaw) * (double)tmpOffsets[5]);
        offsets[4] = (float)(-Math.sin(radiantRotationYaw) * (double)tmpOffsets[0] + Math.cos(radiantRotationYaw) * (double)tmpOffsets[4]);
        offsets[5] = (float)(-Math.sin(radiantRotationYaw) * (double)tmpOffsets[1] + Math.cos(radiantRotationYaw) * (double)tmpOffsets[5]);
        return offsets;
    }

    protected float[] computeEngineExhaustParticleDirection(float rotOffset) {
        float[] directions = new float[3];
        float engineBlast = this.getCurrentEngineSpeed() / (float)this.engineSpeed * 0.2f;
        directions[0] = (float)(Math.sin(-Math.toRadians(this.m_146908_() + rotOffset)) * (double)(-0.05f - engineBlast) + (Math.random() - 0.5) * 0.1);
        directions[1] = 0.01f;
        directions[2] = (float)(Math.cos(Math.toRadians(this.m_146908_() + rotOffset)) * (double)(-0.05f - engineBlast) + (Math.random() - 0.5) * 0.1);
        return directions;
    }

    protected float[] computeEngineFrontSmokeParticleDirection(float rotOffset) {
        float[] directions = new float[3];
        float engineBlast = this.getCurrentEngineSpeed() / (float)this.engineSpeed * 0.2f;
        directions[0] = (float)(Math.sin(-Math.toRadians(this.m_146908_() + rotOffset)) * (double)(0.05f + engineBlast) + (Math.random() - 0.5) * 0.1);
        directions[1] = 0.0f;
        directions[2] = (float)(Math.cos(Math.toRadians(this.m_146908_() + rotOffset)) * (double)(0.05f + engineBlast) + (Math.random() - 0.5) * 0.1);
        return directions;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void playWarningSound() {
        if (this.m_6688_() == Minecraft.m_91087_().f_91074_) {
            if ((double)(this.getHealth() / 40.0f) < 0.3 && this.warningDelay <= 0) {
                this.f_19853_.m_5594_((Player)Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().f_91074_.m_142538_(), new SoundEvent(this.warningSoundResource), SoundSource.BLOCKS, 0.1f * (1.0f - this.getHealth() / 40.0f), 1.0f);
                this.warningDelay = 17;
            } else if ((double)(this.getHealth() / 40.0f) < 0.3) {
                --this.warningDelay;
            }
        }
    }

    private boolean shouldAdjustEngineSpeedByHorizontalControls(float requiredSpeedForHovering) {
        return !(!this.forward() && !this.backward() && !this.left() && !this.right() || this.getCurrentEngineSpeed() > requiredSpeedForHovering && this.upward() || this.getCurrentEngineSpeed() < requiredSpeedForHovering && this.downward());
    }

    private boolean shouldAdjustEngineSpeedWithoutHorizontalControls(float requiredSpeedForHovering) {
        return !(this.forward() || this.backward() || this.left() || this.right() || this.getCurrentEngineSpeed() > requiredSpeedForHovering && this.upward() || this.getCurrentEngineSpeed() < requiredSpeedForHovering && this.downward());
    }

    protected void handleKeyEnableAutoPilot(boolean shouldChange) {
        if (shouldChange) {
            this.simpleControle = !this.simpleControle;
        }
    }

    protected void handleKeyLock(boolean shouldChange) {
        if (shouldChange) {
            this.lockOn = !this.lockOn;
        }
    }

    private void rotateLeft(boolean keyPressed) {
        if (keyPressed) {
            this.rotationControl = 1;
        } else if (this.rotationControl == 1 && !this.rotateRight()) {
            this.rotationControl = 0;
        }
    }

    private void rotateRight(boolean keyPressed) {
        if (keyPressed) {
            this.rotationControl = !this.rotateLeft() ? 2 : 0;
        } else if (this.rotationControl == 2 && !this.rotateLeft()) {
            this.rotationControl = 0;
        }
    }

    protected boolean rotateLeft() {
        return this.rotationControl == 1;
    }

    protected boolean rotateRight() {
        return this.rotationControl == 2;
    }

    protected boolean isBlockDusty(Block block) {
        return block.equals(Blocks.f_49992_) || block.equals(Blocks.f_50135_) || block.equals(Blocks.f_49994_);
    }

    @Override
    public void dropItems() {
        this.dropRecordedItemOrLoot(false);
    }

    private boolean shouldCrashOnLanding() {
        boolean isSpinningViolently;
        Vec3 movement = this.m_20184_();
        double horizontalSpeed = movement.m_165924_();
        double verticalSpeed = Math.abs(movement.f_82480_);
        boolean isSevereTilt = Math.abs(this.pitch) > 40.0f || Math.abs(this.roll) > 40.0f;
        boolean hasHardVerticalImpact = verticalSpeed > 0.45;
        boolean hasHardHorizontalImpact = horizontalSpeed > 0.55;
        boolean bl = isSpinningViolently = Math.abs(this.yawRotationAcceleration) > 0.6f && (verticalSpeed > 0.35 || horizontalSpeed > 0.35);
        if (isSevereTilt && (hasHardVerticalImpact || hasHardHorizontalImpact)) {
            return true;
        }
        return isSpinningViolently;
    }

    protected void changeCurrentEngineSpeed(float changeSpeed) {
        this.setCurrentEngineSpeed(this.getCurrentEngineSpeed() + changeSpeed);
    }

    protected void setCurrentEngineSpeed(float speed) {
        this.currentEngineSpeed = speed;
        if (this.currentEngineSpeed > (float)this.engineSpeed) {
            this.currentEngineSpeed = this.engineSpeed;
        } else if (this.currentEngineSpeed < 0.0f) {
            this.currentEngineSpeed = 0.0f;
        }
    }

    protected float computeRotorSweptArea() {
        return (float)(Math.PI * Math.pow(this.rotorLength, 2.0));
    }

    protected float computeShaftPower() {
        return (float)((double)(this.torque * this.getCurrentEngineSpeed()) * 0.10471975511965977);
    }

    protected float computeRotorForce() {
        return (float)Math.pow((double)(2.4f * this.computeRotorSweptArea()) * Math.pow(this.qualityGrade * this.computeShaftPower(), 2.0), 0.3333333333333333);
    }

    protected float computeVerticalForce() {
        return (1.0f - Math.abs(this.pitch) / 90.0f) * (1.0f - Math.abs(this.roll) / 90.0f) * this.computeRotorForce();
    }

    protected float computeHorizontalForceFrontBack() {
        if (this.pitch <= 90.0f && this.pitch >= -90.0f) {
            return this.pitch / 90.0f * (1.0f - Math.abs(this.roll) / 90.0f) * ((1.0f - Math.abs(this.pitch) / 90.0f) * (1.0f - Math.abs(this.roll) / 90.0f) * 5.0f) * this.computeRotorForce();
        }
        if (this.pitch < 0.0f) {
            return (1.0f + (this.pitch + 90.0f) / 90.0f) * (1.0f - Math.abs(this.roll) / 90.0f) * (Math.abs(this.pitch + 90.0f) / 90.0f * (1.0f - Math.abs(this.roll) / 90.0f) * 5.0f) * this.computeRotorForce();
        }
        return (1.0f - (this.pitch - 90.0f) / 90.0f) * (1.0f - Math.abs(this.roll) / 90.0f) * (Math.abs(this.pitch - 90.0f) / 90.0f * (1.0f - Math.abs(this.roll) / 90.0f) * 5.0f) * this.computeRotorForce();
    }

    protected float computeHorizontalForceLeftRight() {
        return this.roll / 90.0f * (1.0f - this.pitch / 90.0f) * this.computeRotorForce();
    }

    public float getCurrentEngineSpeed() {
        return this.currentEngineSpeed;
    }

    protected float computeRequiredEngineSpeedForHover() {
        float S = 9.81f * (float)this.weight / ((1.0f - Math.abs(this.pitch) / 90.0f) * (1.0f - Math.abs(this.roll) / 90.0f));
        return (float)((double)(1.0f / this.qualityGrade) * Math.sqrt(Math.pow(S, 3.0) / (double)(2.4f * this.computeRotorSweptArea())) / ((double)this.torque * 0.10471975511965977));
    }

    protected float computeThrottleUpDown() {
        return (float)this.enginePower / 735.5f * 2.9481133E-4f;
    }

    protected float computeTorque() {
        float denom = (float)((double)this.engineSpeed * 0.10471975511965977);
        if (denom <= 0.0f) {
            return 0.0f;
        }
        return (float)this.enginePower / denom;
    }
}

