/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items.Fossils;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.items.Fossils.FossilBlockItem;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.util.FossilUtil;
import net.vit.jurassicreborn.common.util.ItemsUtil;
import net.vit.jurassicreborn.common.util.LangUtil;
import net.vit.jurassicreborn.common.util.api.CleanableItem;

public class EncasedFaunaFossilBlockItem
extends FossilBlockItem
implements CleanableItem {
    private final Dinosaur defaultDino;

    public EncasedFaunaFossilBlockItem(Block block, Dinosaur defaultDino, Item.Properties properties) {
        super(block, properties);
        this.defaultDino = defaultDino;
    }

    private Dinosaur readDino(ItemStack stack) {
        Dinosaur dino = FossilUtil.getDino(stack);
        return dino == null || dino == Dinosaur.EMPTY ? this.defaultDino : dino;
    }

    @Override
    public Component m_7626_(ItemStack stack) {
        Dinosaur dino = this.readDino(stack);
        String dinoName = LangUtil.getDinoName(dino).getString();
        return new TextComponent("Encased " + dinoName + " Fossil");
    }

    @Override
    public boolean isCleanable(ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack getCleanedItem(ItemStack stack, Random random) {
        Dinosaur dino = this.readDino(stack);
        String[] bones = dino.getBones();
        LinkedHashMap<String, RegistryObject<Item>> boneMap = ModItems.BONES.get(dino);
        if (boneMap == null || bones == null || bones.length == 0) {
            return ItemStack.f_41583_;
        }
        String boneKey = bones.length > 1 ? bones[random.nextInt(bones.length)] : bones[0];
        Item bone = (Item)boneMap.get(boneKey).get();
        return new ItemStack((ItemLike)bone, 1);
    }

    @Override
    public List<Pair<Float, ItemStack>> getChancedOutputs(ItemStack inputItem) {
        Dinosaur dino = this.readDino(inputItem);
        String[] bones = dino.getBones();
        if (bones == null || bones.length == 0) {
            return new ArrayList<Pair<Float, ItemStack>>();
        }
        float chance = 100.0f / (float)bones.length;
        ArrayList<Pair<Float, ItemStack>> list = new ArrayList<Pair<Float, ItemStack>>();
        for (String bone : bones) {
            Item boneItem = ItemsUtil.getFossilDinosaurBone(dino, bone);
            if (boneItem == null) continue;
            list.add((Pair<Float, ItemStack>)Pair.of((Object)Float.valueOf(chance), (Object)new ItemStack((ItemLike)boneItem)));
        }
        return list;
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (tab == this.m_41471_() || tab == CreativeModeTab.f_40754_) {
            ItemStack stack = new ItemStack((ItemLike)this);
            FossilUtil.setDino(stack, this.defaultDino);
            items.add((Object)stack);
        }
    }
}

