/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.jei.cultivate;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.IntSupplier;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.vit.jurassicreborn.JurassicReborn;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.blocks.entities.cultivator.CultivatorBottomBlock;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.jei.cultivate.CultivatorRecipeExtension;

public class CultivatorRecipeCategory
implements IRecipeCategory<CultivatorRecipeExtension> {
    public static final RecipeType<CultivatorRecipeExtension> TYPE = RecipeType.create((String)"jurassicreborn", (String)"cultivator", CultivatorRecipeExtension.class);
    private static final ResourceLocation TEX = JurassicReborn.resource("textures/gui/cultivator_jei.png");
    private final IDrawable bg;
    private final Component title;
    private final IDrawable icon;
    private List<NutrientBar> nutrientBars = List.of();

    public CultivatorRecipeCategory(IGuiHelper gui) {
        this.bg = gui.createDrawable(TEX, 0, 0, 169, 90);
        this.title = ((CultivatorBottomBlock)((Object)ModBlocks.CULTIVATE_BOTTOM.get())).m_49954_();
        this.icon = gui.createDrawableItemStack(new ItemStack((ItemLike)ModBlocks.CULTIVATE_BOTTOM.get()));
    }

    public RecipeType<CultivatorRecipeExtension> getRecipeType() {
        return TYPE;
    }

    public ResourceLocation getUid() {
        return TYPE.getUid();
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.bg;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Class<? extends CultivatorRecipeExtension> getRecipeClass() {
        return CultivatorRecipeExtension.class;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CultivatorRecipeExtension recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 41, 7).addItemStack(new ItemStack((ItemLike)ModItems.SYRINGES.get(recipe.getDinosaur()).get(), 1));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 106, 7).addItemStack(new ItemStack((ItemLike)ModItems.hatchedDinoEggs.get(recipe.getDinosaur()).get(), 1));
        Dinosaur dino = recipe.getDinosaur();
        Object[] objectArray = new NutrientBar[4];
        objectArray[0] = new NutrientBar(dino::getProximates, 0);
        objectArray[1] = new NutrientBar(dino::getMinerals, 1);
        objectArray[2] = new NutrientBar(dino::getVitamins, 2);
        objectArray[3] = new NutrientBar(dino::getLipids, 3);
        this.nutrientBars = Lists.newArrayList((Object[])objectArray);
    }

    public void draw(CultivatorRecipeExtension recipe, PoseStack poseStack, double mouseX, double mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEX);
        for (NutrientBar bar : this.nutrientBars) {
            bar.render(poseStack);
        }
    }

    private static class NutrientBar {
        private final IntSupplier supplier;
        private final int id;

        NutrientBar(IntSupplier supplier, int id) {
            this.supplier = supplier;
            this.id = id;
        }

        void render(PoseStack poseStack) {
            int value = this.supplier.getAsInt();
            GuiComponent.m_93133_((PoseStack)poseStack, (int)9, (int)(30 + this.id * 16), (float)0.0f, (float)(91 + this.id * 9), (int)(value * 150 / 3000), (int)9, (int)256, (int)256);
        }
    }
}

