/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MicroraptorEntity;
import net.vit.jurassicreborn.common.network.Network;

public class MicroraptorDismountMessage {
    private final int entityId;

    public MicroraptorDismountMessage(int entityId) {
        this.entityId = entityId;
    }

    public MicroraptorDismountMessage(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
    }

    public static void encode(MicroraptorDismountMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
    }

    public static MicroraptorDismountMessage decode(FriendlyByteBuf buf) {
        return new MicroraptorDismountMessage(buf);
    }

    public static void handle(MicroraptorDismountMessage msg, Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> {
            ServerPlayer serverPlayer = ctx.getSender();
            if (serverPlayer != null) {
                MicroraptorEntity microraptor;
                Entity entity = serverPlayer.f_19853_.m_6815_(msg.entityId);
                if (entity instanceof MicroraptorEntity && (microraptor = (MicroraptorEntity)entity).isOwner((Player)serverPlayer)) {
                    microraptor.m_8127_();
                    Network.sendToAllNear(serverPlayer.f_19853_, microraptor.m_142538_(), 64.0, msg);
                }
            } else {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Client.handle(msg));
            }
        });
        ctx.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class Client {
        private Client() {
        }

        static void handle(MicroraptorDismountMessage msg) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            Entity entity = level.m_6815_(msg.entityId);
            if (entity != null) {
                entity.m_8127_();
            }
        }
    }
}

