/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.network;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.vit.jurassicreborn.JurassicReborn;
import net.vit.jurassicreborn.common.network.CarEntityPlayRecord;
import net.vit.jurassicreborn.common.network.ChangeStationMessage;
import net.vit.jurassicreborn.common.network.FordExplorerChangeStateMessage;
import net.vit.jurassicreborn.common.network.FordExplorerSnowChangeStateMessage;
import net.vit.jurassicreborn.common.network.FordExplorerSnowUpdatePositionStateMessage;
import net.vit.jurassicreborn.common.network.FordExplorerUpdatePositionStateMessage;
import net.vit.jurassicreborn.common.network.MicroraptorDismountMessage;
import net.vit.jurassicreborn.common.network.MonorailChangeStateMessage;
import net.vit.jurassicreborn.common.network.MonorailUpdatePositionStateMessage;
import net.vit.jurassicreborn.common.network.NameFeederPacket;
import net.vit.jurassicreborn.common.network.PaddockSignPlacePacket;
import net.vit.jurassicreborn.common.network.SetHologramDinosaurPacket;
import net.vit.jurassicreborn.common.network.SetIncubatorTempServerboundPacket;
import net.vit.jurassicreborn.common.network.SetOrderPacket;
import net.vit.jurassicreborn.common.network.SwitchHybridizerCombinatorMode;
import net.vit.jurassicreborn.common.network.SwitchSeatMessage;
import net.vit.jurassicreborn.common.network.SyncFeederTrackerPacket;
import net.vit.jurassicreborn.common.network.TrackDinosaurPacket;
import net.vit.jurassicreborn.common.network.UpdateVehicleControlMessage;
import net.vit.jurassicreborn.common.util.message.OpenPaleoPadEntityMessage;

public class Network {
    public static Network INSTANCE;
    public static final String version = "1";
    private final SimpleChannel channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)JurassicReborn.resource("main")).serverAcceptedVersions(v -> version.equals(v) || NetworkRegistry.ABSENT.equals(v) || NetworkRegistry.ACCEPTVANILLA.equals(v)).clientAcceptedVersions(v -> version.equals(v) || NetworkRegistry.ABSENT.equals(v) || NetworkRegistry.ACCEPTVANILLA.equals(v)).networkProtocolVersion(() -> "1").simpleChannel();
    public static int id;
    public static final List<BlockEntity> ENTITIES;
    public static HashMap<BlockPos, Int2ObjectArrayMap<ItemStack>> slotMap;

    private Network() {
        this.channel.registerMessage(id++, SwitchHybridizerCombinatorMode.class, SwitchHybridizerCombinatorMode::write, SwitchHybridizerCombinatorMode::read, SwitchHybridizerCombinatorMode::handle);
        this.channel.registerMessage(id++, SetIncubatorTempServerboundPacket.class, SetIncubatorTempServerboundPacket::write, SetIncubatorTempServerboundPacket::read, SetIncubatorTempServerboundPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        this.channel.registerMessage(id++, OpenPaleoPadEntityMessage.class, OpenPaleoPadEntityMessage::write, OpenPaleoPadEntityMessage::read, OpenPaleoPadEntityMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        this.channel.registerMessage(id++, PaddockSignPlacePacket.class, PaddockSignPlacePacket::encode, PaddockSignPlacePacket::decode, PaddockSignPlacePacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        this.channel.registerMessage(id++, SetHologramDinosaurPacket.class, SetHologramDinosaurPacket::encode, SetHologramDinosaurPacket::decode, SetHologramDinosaurPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        this.channel.registerMessage(id++, TrackDinosaurPacket.class, TrackDinosaurPacket::toBytes, TrackDinosaurPacket::new, TrackDinosaurPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        this.channel.registerMessage(id++, SetOrderPacket.class, SetOrderPacket::toBytes, SetOrderPacket::new, SetOrderPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        this.channel.registerMessage(id++, NameFeederPacket.class, NameFeederPacket::encode, NameFeederPacket::decode, NameFeederPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        this.channel.registerMessage(id++, SyncFeederTrackerPacket.class, SyncFeederTrackerPacket::encode, SyncFeederTrackerPacket::decode, SyncFeederTrackerPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        this.channel.registerMessage(id++, FordExplorerChangeStateMessage.class, FordExplorerChangeStateMessage::encode, FordExplorerChangeStateMessage::decode, FordExplorerChangeStateMessage::handle);
        this.channel.registerMessage(id++, FordExplorerSnowChangeStateMessage.class, FordExplorerSnowChangeStateMessage::encode, FordExplorerSnowChangeStateMessage::decode, FordExplorerSnowChangeStateMessage::handle);
        this.channel.registerMessage(id++, MonorailChangeStateMessage.class, MonorailChangeStateMessage::encode, MonorailChangeStateMessage::decode, MonorailChangeStateMessage::handle);
        this.channel.registerMessage(id++, CarEntityPlayRecord.class, CarEntityPlayRecord::encode, CarEntityPlayRecord::decode, CarEntityPlayRecord::handle);
        this.channel.registerMessage(id++, UpdateVehicleControlMessage.class, UpdateVehicleControlMessage::encode, UpdateVehicleControlMessage::decode, UpdateVehicleControlMessage::handle);
        this.channel.registerMessage(id++, FordExplorerUpdatePositionStateMessage.class, FordExplorerUpdatePositionStateMessage::encode, FordExplorerUpdatePositionStateMessage::new, FordExplorerUpdatePositionStateMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        this.channel.registerMessage(id++, FordExplorerSnowUpdatePositionStateMessage.class, FordExplorerSnowUpdatePositionStateMessage::encode, FordExplorerSnowUpdatePositionStateMessage::new, FordExplorerSnowUpdatePositionStateMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        this.channel.registerMessage(id++, MonorailUpdatePositionStateMessage.class, MonorailUpdatePositionStateMessage::encode, MonorailUpdatePositionStateMessage::new, MonorailUpdatePositionStateMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        this.channel.registerMessage(id++, SwitchSeatMessage.class, SwitchSeatMessage::encode, SwitchSeatMessage::decode, SwitchSeatMessage::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        this.channel.registerMessage(id++, ChangeStationMessage.class, ChangeStationMessage::encode, ChangeStationMessage::decode, ChangeStationMessage::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        this.channel.registerMessage(id++, MicroraptorDismountMessage.class, MicroraptorDismountMessage::encode, MicroraptorDismountMessage::decode, MicroraptorDismountMessage::handle);
    }

    public static void init() {
        INSTANCE = new Network();
    }

    public static void sendToAllNear(Level level, BlockPos pos, double radius, Object msg) {
        Network.INSTANCE.channel.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, radius, level.m_46472_())), msg);
    }

    public static void sendToAllNear(Level level, BlockPos pos, Object msg) {
        Network.sendToAllNear(level, pos, 64.0, msg);
    }

    public static void switchHybridizerCombinerMode(boolean mode, BlockPos pos, ResourceKey<Level> dimension) {
        Network.INSTANCE.channel.sendToServer((Object)new SwitchHybridizerCombinatorMode(mode, pos, dimension));
    }

    public static void setIncubatorTemperature(BlockPos incubator, int slot, int temp, ResourceKey<Level> dimension) {
        Network.INSTANCE.channel.sendToServer((Object)new SetIncubatorTempServerboundPacket(incubator, slot, temp, dimension));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRemovedEntities() {
        List<BlockEntity> list = ENTITIES;
        synchronized (list) {
            ENTITIES.removeIf(BlockEntity::m_58901_);
        }
    }

    public static void sendToServer(Object message) {
        Network.INSTANCE.channel.sendToServer(message);
    }

    public static void sendTo(ServerPlayer player, Object message) {
        Network.INSTANCE.channel.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    static {
        id = 0;
        ENTITIES = Collections.synchronizedList(new ArrayList());
        slotMap = new HashMap();
    }
}

