/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.vit.jurassicreborn.common.util.block.TemperatureControl;

public class SetIncubatorTempServerboundPacket {
    private BlockPos pos;
    private int slotIndex;
    private int temp;
    private ResourceKey<Level> dimension;

    public SetIncubatorTempServerboundPacket(BlockPos pos, int slotIndex, int temperature, ResourceKey<Level> dim) {
        this.pos = pos;
        this.slotIndex = slotIndex;
        this.temp = temperature;
        this.dimension = dim;
    }

    public static void handle(SetIncubatorTempServerboundPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            TemperatureControl temperatureControl;
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_20194_().m_129880_(packet.dimension);
            if (level == null || level.f_46443_) {
                return;
            }
            BlockEntity blockEntity = level.m_7702_(packet.pos);
            if (blockEntity == null) {
                blockEntity = level.m_46745_(packet.pos).m_7702_(packet.pos);
            }
            if (blockEntity instanceof TemperatureControl && packet.slotIndex < (temperatureControl = (TemperatureControl)blockEntity).getTemperatureCount()) {
                temperatureControl.setTemperature(packet.slotIndex, packet.temp);
                blockEntity.m_6596_();
                level.m_7260_(packet.pos, blockEntity.m_58900_(), blockEntity.m_58900_(), 3);
            }
        });
        context.setPacketHandled(true);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeInt(this.slotIndex);
        buffer.writeInt(this.temp);
        buffer.m_130085_(this.dimension.m_135782_());
    }

    public static SetIncubatorTempServerboundPacket read(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        int slotIndex = buffer.readInt();
        int temp = buffer.readInt();
        ResourceLocation dimId = buffer.m_130281_();
        ResourceKey dim = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimId);
        return new SetIncubatorTempServerboundPacket(pos, slotIndex, temp, (ResourceKey<Level>)dim);
    }
}

