/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen;

import com.mojang.serialization.Codec;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.blocks.fossil.FloraFossil;

public class OreVeinFeature
extends Feature<OreConfiguration> {
    public OreVeinFeature(Codec<OreConfiguration> p_66531_) {
        super(p_66531_);
    }

    public boolean m_142674_(FeaturePlaceContext<OreConfiguration> p_160177_) {
        Random random = p_160177_.m_159776_();
        BlockPos blockpos = p_160177_.m_159777_();
        WorldGenLevel worldgenlevel = p_160177_.m_159774_();
        OreConfiguration oreconfiguration = (OreConfiguration)p_160177_.m_159778_();
        float f = random.nextFloat() * (float)Math.PI;
        float f1 = (float)oreconfiguration.f_67839_ / 8.0f;
        int i = Mth.m_14167_((float)(((float)oreconfiguration.f_67839_ / 16.0f * 2.0f + 1.0f) / 2.0f));
        double d0 = (double)blockpos.m_123341_() + Math.sin(f) * (double)f1;
        double d1 = (double)blockpos.m_123341_() - Math.sin(f) * (double)f1;
        double d2 = (double)blockpos.m_123343_() + Math.cos(f) * (double)f1;
        double d3 = (double)blockpos.m_123343_() - Math.cos(f) * (double)f1;
        int j = 2;
        double d4 = blockpos.m_123342_() + random.nextInt(3) - 2;
        double d5 = blockpos.m_123342_() + random.nextInt(3) - 2;
        int k = blockpos.m_123341_() - Mth.m_14167_((float)f1) - i;
        int l = blockpos.m_123342_() - 2 - i;
        int i1 = blockpos.m_123343_() - Mth.m_14167_((float)f1) - i;
        int j1 = 2 * (Mth.m_14167_((float)f1) + i);
        int k1 = 2 * (2 + i);
        for (int l1 = k; l1 <= k + j1; ++l1) {
            for (int i2 = i1; i2 <= i1 + j1; ++i2) {
                if (l > worldgenlevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, l1, i2)) continue;
                return this.doPlace(worldgenlevel, random, oreconfiguration, d0, d1, d2, d3, d4, d5, k, l, i1, j1, k1);
            }
        }
        return false;
    }

    protected boolean doPlace(WorldGenLevel p_66533_, Random rand, OreConfiguration p_66535_, double p_66536_, double p_66537_, double p_66538_, double p_66539_, double p_66540_, double p_66541_, int p_66542_, int p_66543_, int p_66544_, int p_66545_, int p_66546_) {
        int i = 0;
        BitSet bitset = new BitSet(p_66545_ * p_66546_ * p_66545_);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int j = p_66535_.f_67839_;
        double[] adouble = new double[j * 4];
        for (int k = 0; k < j; ++k) {
            float f = (float)k / (float)j;
            double d0 = Mth.m_14139_((double)f, (double)p_66536_, (double)p_66537_);
            double d1 = Mth.m_14139_((double)f, (double)p_66540_, (double)p_66541_);
            double d2 = Mth.m_14139_((double)f, (double)p_66538_, (double)p_66539_);
            double d3 = rand.nextDouble() * (double)j / 16.0;
            double d4 = ((double)(Mth.m_14031_((float)((float)Math.PI * f)) + 1.0f) * d3 + 1.0) / 2.0;
            adouble[k * 4] = d0;
            adouble[k * 4 + 1] = d1;
            adouble[k * 4 + 2] = d2;
            adouble[k * 4 + 3] = d4;
        }
        for (int l3 = 0; l3 < j - 1; ++l3) {
            if (adouble[l3 * 4 + 3] <= 0.0) continue;
            for (int i4 = l3 + 1; i4 < j; ++i4) {
                double d12;
                double d10;
                double d8;
                double d14;
                if (adouble[i4 * 4 + 3] <= 0.0 || !((d14 = adouble[l3 * 4 + 3] - adouble[i4 * 4 + 3]) * d14 > (d8 = adouble[l3 * 4] - adouble[i4 * 4]) * d8 + (d10 = adouble[l3 * 4 + 1] - adouble[i4 * 4 + 1]) * d10 + (d12 = adouble[l3 * 4 + 2] - adouble[i4 * 4 + 2]) * d12)) continue;
                if (d14 > 0.0) {
                    adouble[i4 * 4 + 3] = -1.0;
                    continue;
                }
                adouble[l3 * 4 + 3] = -1.0;
            }
        }
        try (BulkSectionAccess bulksectionaccess = new BulkSectionAccess((LevelAccessor)p_66533_);){
            for (int j4 = 0; j4 < j; ++j4) {
                double d9 = adouble[j4 * 4 + 3];
                if (d9 < 0.0) continue;
                double d11 = adouble[j4 * 4];
                double d13 = adouble[j4 * 4 + 1];
                double d15 = adouble[j4 * 4 + 2];
                int k4 = Math.max(Mth.m_14107_((double)(d11 - d9)), p_66542_);
                int l = Math.max(Mth.m_14107_((double)(d13 - d9)), p_66543_);
                int i1 = Math.max(Mth.m_14107_((double)(d15 - d9)), p_66544_);
                int j1 = Math.max(Mth.m_14107_((double)(d11 + d9)), k4);
                int k1 = Math.max(Mth.m_14107_((double)(d13 + d9)), l);
                int l1 = Math.max(Mth.m_14107_((double)(d15 + d9)), i1);
                for (int i2 = k4; i2 <= j1; ++i2) {
                    double d5 = ((double)i2 + 0.5 - d11) / d9;
                    if (!(d5 * d5 < 1.0)) continue;
                    for (int j2 = l; j2 <= k1; ++j2) {
                        double d6 = ((double)j2 + 0.5 - d13) / d9;
                        if (!(d5 * d5 + d6 * d6 < 1.0)) continue;
                        for (int k2 = i1; k2 <= l1; ++k2) {
                            LevelChunkSection levelchunksection;
                            int l2;
                            double d7 = ((double)k2 + 0.5 - d15) / d9;
                            if (!(d5 * d5 + d6 * d6 + d7 * d7 < 1.0) || p_66533_.m_151562_(j2) || bitset.get(l2 = i2 - p_66542_ + (j2 - p_66543_) * p_66545_ + (k2 - p_66544_) * p_66545_ * p_66546_)) continue;
                            bitset.set(l2);
                            blockpos$mutableblockpos.m_122178_(i2, j2, k2);
                            if (!p_66533_.m_180807_((BlockPos)blockpos$mutableblockpos) || (levelchunksection = bulksectionaccess.m_156104_((BlockPos)blockpos$mutableblockpos)) == null) continue;
                            int i3 = SectionPos.m_123207_((int)i2);
                            int j3 = SectionPos.m_123207_((int)j2);
                            int k3 = SectionPos.m_123207_((int)k2);
                            BlockState blockstate = levelchunksection.m_62982_(i3, j3, k3);
                            for (OreConfiguration.TargetBlockState targetState : p_66535_.f_161005_) {
                                if (!targetState.f_161032_.m_7715_(blockstate, rand)) continue;
                                if (rand.nextInt(5) == 1) {
                                    if (blockstate.m_60734_() != Blocks.f_152550_) {
                                        levelchunksection.m_62991_(i3, j3, k3, (BlockState)((FloraFossil)ModBlocks.FLORA_FOSSIL.get()).m_49966_().m_61124_((Property)FloraFossil.VARIANT, (Comparable)Integer.valueOf(rand.nextInt(4))), false);
                                        continue;
                                    }
                                    levelchunksection.m_62991_(i3, j3, k3, (BlockState)((FloraFossil)ModBlocks.DEEPSLATE_FLORA_FOSSIL.get()).m_49966_().m_61124_((Property)FloraFossil.VARIANT, (Comparable)Integer.valueOf(rand.nextInt(4))), false);
                                    continue;
                                }
                                levelchunksection.m_62991_(i3, j3, k3, targetState.f_161033_, false);
                            }
                        }
                    }
                }
            }
        }
        return i > 0;
    }

    public static boolean canPlaceOre(BlockState p_160170_, Function<BlockPos, BlockState> p_160171_, Random p_160172_, OreConfiguration p_160173_, OreConfiguration.TargetBlockState p_160174_, BlockPos.MutableBlockPos p_160175_) {
        if (!p_160174_.f_161032_.m_7715_(p_160170_, p_160172_)) {
            return false;
        }
        if (OreVeinFeature.shouldSkipAirCheck(p_160172_, p_160173_.f_161006_)) {
            return true;
        }
        return !OreVeinFeature.m_159750_(p_160171_, (BlockPos)p_160175_);
    }

    protected static boolean shouldSkipAirCheck(Random p_160179_, float p_160180_) {
        if (p_160180_ <= 0.0f) {
            return true;
        }
        if (p_160180_ >= 1.0f) {
            return false;
        }
        return p_160179_.nextFloat() >= p_160180_;
    }
}

