/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jurassicreborn")
public class VillageAddition {
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registry.f_122883_, (ResourceLocation)new ResourceLocation("minecraft", "empty"));

    private static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation poolRL, String nbtPieceRL, int weight) {
        Holder emptyProcessorList = processorListRegistry.m_206081_(EMPTY_PROCESSOR_LIST_KEY);
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(poolRL);
        if (pool == null) {
            return;
        }
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.m_210512_((String)nbtPieceRL, (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.f_210560_.add(piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.f_210559_);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.f_210559_ = listOfPieceEntries;
    }

    @SubscribeEvent
    public static void addNewVillageBuilding(ServerAboutToStartEvent event) {
        Registry templatePoolRegistry = (Registry)event.getServer().m_206579_().m_6632_(Registry.f_122884_).orElseThrow();
        Registry processorListRegistry = (Registry)event.getServer().m_206579_().m_6632_(Registry.f_122883_).orElseThrow();
        VillageAddition.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/plains/houses"), "jurassicreborn:plains_geneticist_house", 3);
        VillageAddition.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/desert/houses"), "jurassicreborn:desert_geneticist_house", 3);
        VillageAddition.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/savanna/houses"), "jurassicreborn:savanna_geneticist_house", 3);
        VillageAddition.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/snowy/houses"), "jurassicreborn:snowy_geneticist_house", 3);
        VillageAddition.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/taiga/houses"), "jurassicreborn:taiga_geneticist_house", 3);
        VillageAddition.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/plains/houses"), "jurassicreborn:plains_paleontologist_house", 1);
        VillageAddition.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/desert/houses"), "jurassicreborn:desert_paleontologist_house", 3);
        VillageAddition.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/savanna/houses"), "jurassicreborn:savanna_paleontologist_house", 3);
        VillageAddition.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/snowy/houses"), "jurassicreborn:snowy_paleontologist_house", 3);
        VillageAddition.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/taiga/houses"), "jurassicreborn:taiga_paleontologist_house", 3);
    }
}

