/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen.villager;

import com.mojang.datafixers.util.Pair;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class JurassicStructureMapForEmeralds
implements VillagerTrades.ItemListing {
    private static final float PRICE_MULTIPLIER = 0.2f;
    private final int emeraldCost;
    private final ResourceKey<ConfiguredStructureFeature<?, ?>> structureKey;
    private final MapDecoration.Type markerType;
    private final int maxUses;
    private final int villagerXp;
    private final String translationKey;

    public JurassicStructureMapForEmeralds(int emeraldCost, ResourceKey<ConfiguredStructureFeature<?, ?>> structureKey, String translationKey) {
        this(emeraldCost, structureKey, MapDecoration.Type.RED_X, 12, 5, translationKey);
    }

    public JurassicStructureMapForEmeralds(int emeraldCost, ResourceKey<ConfiguredStructureFeature<?, ?>> structureKey, MapDecoration.Type markerType, int maxUses, int villagerXp, String translationKey) {
        this.emeraldCost = emeraldCost;
        this.structureKey = structureKey;
        this.markerType = markerType;
        this.maxUses = maxUses;
        this.villagerXp = villagerXp;
        this.translationKey = translationKey;
    }

    public MerchantOffer m_5670_(Entity trader, Random random) {
        Level level = trader.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Registry registry = serverLevel.m_5962_().m_175515_(Registry.f_122882_);
        Optional structureHolder = registry.m_203636_(this.structureKey);
        if (structureHolder.isEmpty()) {
            return null;
        }
        HolderSet.Direct structures = HolderSet.m_205809_((Holder[])new Holder[]{(Holder)structureHolder.get()});
        ChunkGenerator generator = serverLevel.m_7726_().m_8481_();
        Optional<Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>>> result = this.findNearestStructure(generator, serverLevel, (HolderSet<ConfiguredStructureFeature<?, ?>>)structures, trader.m_142538_());
        if (result.isEmpty()) {
            return null;
        }
        BlockPos structurePos = (BlockPos)result.get().getFirst();
        ItemStack map = MapItem.m_42886_((Level)serverLevel, (int)structurePos.m_123341_(), (int)structurePos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
        MapItem.m_42850_((ServerLevel)serverLevel, (ItemStack)map);
        MapItemSavedData.m_77925_((ItemStack)map, (BlockPos)structurePos, (String)"+", (MapDecoration.Type)this.markerType);
        map.m_41714_((Component)new TranslatableComponent(this.translationKey));
        return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldCost), new ItemStack((ItemLike)Items.f_42522_), map, this.maxUses, this.villagerXp, 0.2f);
    }

    private Optional<Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>>> findNearestStructure(ChunkGenerator generator, ServerLevel level, HolderSet<ConfiguredStructureFeature<?, ?>> structures, BlockPos origin) {
        try {
            Method method = generator.getClass().getMethod("findNearestMapStructure", ServerLevel.class, HolderSet.class, BlockPos.class, Integer.TYPE, Boolean.TYPE);
            Object result = method.invoke((Object)generator, level, structures, origin, 100, true);
            return Optional.ofNullable((Pair)result);
        }
        catch (NoSuchMethodException method) {
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            exception.printStackTrace();
            return Optional.empty();
        }
        try {
            Method method = generator.getClass().getMethod("findNearestMapStructure", ServerLevel.class, HolderSet.class, BlockPos.class, Integer.TYPE, Boolean.TYPE, Long.TYPE);
            Object result = method.invoke((Object)generator, level, structures, origin, 100, true, level.m_7328_());
            return Optional.ofNullable((Pair)result);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            exception.printStackTrace();
            return Optional.empty();
        }
    }
}

