/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity;

import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.citadel.client.model.basic.BasicEntityModel;
import com.github.alexthe666.citadel.client.model.container.TabulaModelContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.model.Model;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.client.model.AnimatableModel;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimator;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.GrowthStage;
import net.vit.jurassicreborn.common.items.misc.SkeletonPoseHelper;
import net.vit.jurassicreborn.common.legacy.tabula.TabulaModelHelper;

@OnlyIn(value=Dist.CLIENT)
public class DinosaurRenderInfo {
    private static TabulaModel DEFAULT_EGG_MODEL;
    private static ResourceLocation DEFAULT_EGG_TEXTURE;
    private final Dinosaur dinosaur;
    private final EntityAnimator<?> animator;
    private final AnimatableModel modelAdult;
    private final AnimatableModel modelInfant;
    private final AnimatableModel modelJuvenile;
    private final AnimatableModel modelAdolescent;
    private final List<AnimatableModel> modelSkeletons;
    private TabulaModel eggModel;
    private ResourceLocation eggTexture;

    public DinosaurRenderInfo(Dinosaur dinosaur, EntityAnimator<?> animator) {
        this.dinosaur = dinosaur;
        this.animator = animator;
        this.modelAdult = this.loadModel(GrowthStage.ADULT);
        this.modelInfant = this.loadModel(GrowthStage.INFANT);
        this.modelJuvenile = this.loadModel(GrowthStage.JUVENILE);
        this.modelAdolescent = this.loadModel(GrowthStage.ADOLESCENT);
        this.modelSkeletons = this.loadSkeletonModels();
        try {
            String name = dinosaur.getName().toLowerCase(Locale.ENGLISH);
            this.eggModel = new TabulaModel(TabulaModelHelper.loadTabulaModel("/assets/jurassicreborn/models/entities/egg/" + name));
            this.eggTexture = new ResourceLocation("jurassicreborn", "textures/entities/egg/" + name + ".png");
        }
        catch (Exception e) {
            this.eggModel = DEFAULT_EGG_MODEL;
            this.eggTexture = DEFAULT_EGG_TEXTURE;
        }
    }

    public BasicEntityModel<DinosaurEntity> getModel(GrowthStage stage, byte skeletonVariant) {
        switch (stage) {
            case INFANT: {
                return this.modelInfant;
            }
            case JUVENILE: {
                return this.modelJuvenile;
            }
            case ADOLESCENT: {
                return this.modelAdolescent;
            }
            case SKELETON: {
                int idx = Byte.toUnsignedInt(skeletonVariant);
                if (idx >= this.modelSkeletons.size()) {
                    idx = 0;
                }
                return (BasicEntityModel)this.modelSkeletons.get(idx);
            }
        }
        return this.modelAdult;
    }

    public Model getEggModel() {
        return this.eggModel;
    }

    public ResourceLocation getEggTexture() {
        return this.eggTexture;
    }

    public EntityAnimator<?> getModelAnimator(GrowthStage stage) {
        if (stage == GrowthStage.SKELETON) {
            return null;
        }
        return this.animator;
    }

    public AnimatableModel loadModel(GrowthStage stage) {
        if (!this.dinosaur.doesSupportGrowthStage(stage)) {
            return this.getModelAdult();
        }
        return new AnimatableModel(this.dinosaur.getModelContainer(stage), this.getModelAnimator(stage));
    }

    private List<AnimatableModel> loadSkeletonModels() {
        ArrayList<AnimatableModel> models = new ArrayList<AnimatableModel>();
        List<TabulaModelContainer> containers = SkeletonPoseHelper.getPoseModels(this.dinosaur);
        for (TabulaModelContainer container : containers) {
            models.add(new AnimatableModel(container, null));
        }
        return models;
    }

    public Dinosaur getDinosaur() {
        return this.dinosaur;
    }

    public AnimatableModel getModelAdult() {
        return this.modelAdult;
    }

    static {
        try {
            DEFAULT_EGG_MODEL = new TabulaModel(TabulaModelHelper.loadTabulaModel("/assets/jurassicreborn/models/entities/egg/tyrannosaurus"));
            DEFAULT_EGG_TEXTURE = new ResourceLocation("jurassicreborn", "textures/entities/egg/tyrannosaurus.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

