/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity.animation.entity;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import net.vit.jurassicreborn.client.model.AnimatableModel;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimator;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DeinosuchusEntity;

public class DeinosuchusAnimator
extends EntityAnimator<DeinosuchusEntity> {
    @Override
    protected void performAnimations(AnimatableModel model, DeinosuchusEntity entity, float limbSwing, float limbSwingAmount, float ticks, float rotationYaw, float rotationPitch, float scale) {
        AdvancedModelBox body = model.getCube("Body");
        AdvancedModelBox neck1 = model.getCube("Neck1");
        AdvancedModelBox head = model.getCube("Head");
        AdvancedModelBox jaw = model.getCube("Jaw");
        AdvancedModelBox tail1 = model.getCube("Tail1");
        AdvancedModelBox tail2 = model.getCube("Tail2");
        AdvancedModelBox tail3 = model.getCube("Tail3");
        AdvancedModelBox tail4 = model.getCube("Tail4");
        AdvancedModelBox tail5 = model.getCube("Tail5");
        AdvancedModelBox fl = model.getCube("FrontLeftLeg");
        AdvancedModelBox fr = model.getCube("FrontRightLeg");
        AdvancedModelBox bl = model.getCube("BackLeftLeg");
        AdvancedModelBox br = model.getCube("BackRightLeg");
        AdvancedModelBox[] neckChain = new AdvancedModelBox[]{neck1, head};
        AdvancedModelBox[] tailChain = new AdvancedModelBox[]{tail5, tail4, tail3, tail2, tail1};
        float idleSpeed = 0.1f;
        float idleDeg = 0.1f;
        float walkSpeed = 0.7f;
        float walkDeg = 0.45f;
        float runSpeed = 1.2f;
        float runDeg = 0.7f;
        float swimSpeed = 0.9f;
        float swimDeg = 0.45f;
        float tailIdleFreq = idleSpeed / 4.0f;
        float tailWalkFreq = walkSpeed / 4.0f;
        float tailRunFreq = runSpeed / 4.0f;
        float tailSwimFreq = swimSpeed / 8.0f;
        boolean swimming = entity.m_20069_();
        boolean running = !swimming && (entity.m_20142_() || limbSwingAmount > 0.55f);
        boolean walking = !swimming && !running && limbSwingAmount > 0.08f;
        model.bob(body, idleSpeed, 0.05f, false, ticks, 1.0f);
        model.chainWave(neckChain, idleSpeed * 0.9f, idleDeg * 0.35f, -2.0, ticks, 1.0f);
        model.chainSwing(neckChain, idleSpeed * 0.8f, idleDeg * 0.25f, -2.0, ticks, 1.0f);
        if (!entity.isCarcass()) {
            jaw.rotateAngleX += (float)Math.sin(ticks * 0.07f) * 0.02f;
        }
        model.chainSwing(tailChain, tailIdleFreq, 0.18f, -2.0, ticks, 1.0f);
        model.chainWave(tailChain, tailIdleFreq * 0.8f, 0.05f, -2.0, ticks, 1.0f);
        if (walking) {
            model.chainSwing(tailChain, tailWalkFreq, 0.22f, -2.0, limbSwing, limbSwingAmount);
            model.chainWave(tailChain, tailWalkFreq * 0.9f, 0.06f, -2.0, limbSwing, limbSwingAmount);
        }
        if (running) {
            model.chainSwing(tailChain, tailRunFreq, 0.24f, -2.0, limbSwing, limbSwingAmount);
            model.chainWave(tailChain, tailRunFreq * 0.9f, 0.07f, -2.0, limbSwing, limbSwingAmount);
        }
        if (swimming) {
            model.chainSwing(tailChain, tailSwimFreq, 0.45f, -2.0, ticks, 1.0f);
            model.chainWave(tailChain, tailSwimFreq * 0.5f, 0.15f, -2.0, ticks, 1.0f);
        }
    }
}

