/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity.vehicle;

import com.github.alexthe666.citadel.client.model.ITabulaModelAnimator;
import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.citadel.client.model.container.TabulaModelContainer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.client.render.entity.vehicle.CarAnimator;
import net.vit.jurassicreborn.common.RebornConfig;
import net.vit.jurassicreborn.common.entities.vehicle.VehicleEntity;
import net.vit.jurassicreborn.common.legacy.tabula.TabulaModelHelper;
import net.vit.jurassicreborn.common.util.MathUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public abstract class CarRenderer<E extends VehicleEntity>
extends EntityRenderer<E> {
    private static final ResourceLocation[] DESTROY_STAGES = (ResourceLocation[])IntStream.range(0, 10).mapToObj(i -> new ResourceLocation("textures/block/destroy_stage_" + i + ".png")).toArray(ResourceLocation[]::new);
    private final CarAnimator animator;
    private final ResourceLocation texture;
    private final TabulaModel model;

    protected CarRenderer(EntityRendererProvider.Context ctx, String carName, CarAnimator animator) {
        super(ctx);
        this.animator = animator;
        this.texture = new ResourceLocation("jurassicreborn", "textures/entities/" + carName + "/" + carName + ".png");
        try {
            String path = "/assets/jurassicreborn/models/entities/" + carName + "/" + carName + ".tbl";
            TabulaModelContainer container = TabulaModelHelper.loadTabulaModel(path);
            if (container == null) {
                throw new IllegalArgumentException("Tabula model not found: " + path);
            }
            this.model = new TabulaModel(container, (ITabulaModelAnimator)animator);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to load Tabula model for " + carName, ex);
        }
    }

    public void render(E car, float entityYaw, float partialTicks, PoseStack pose, MultiBufferSource buffer, int packedLight) {
        this.animator.partialTicks = partialTicks;
        pose.m_85836_();
        pose.m_252880_(0.0f, 1.25f, 0.0f);
        pose.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        CarRenderer.applySuspensionPitchRoll(car, partialTicks, pose);
        pose.m_85841_(-1.0f, -1.0f, 1.0f);
        this.animator.setRotationAngles(this.model, (VehicleEntity)((Object)car), 0.0f, 0.0f, (float)((VehicleEntity)((Object)car)).f_19797_ + partialTicks, car.m_146908_(), car.m_146909_(), 0.0625f);
        VertexConsumer vc = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTextureLocation(car)));
        this.model.m_7695_(pose, vc, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        int stage = Math.min(9, 9 - (int)(((VehicleEntity)((Object)car)).getHealth() / 40.0f * 10.0f));
        if (stage >= 0) {
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            VertexConsumer damage = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)DESTROY_STAGES[stage]));
            this.model.m_7695_(pose, damage, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.5f);
            RenderSystem.m_69461_();
        }
        pose.m_85849_();
        super.m_7392_(car, entityYaw, partialTicks, pose, buffer, packedLight);
    }

    private static void applySuspensionPitchRoll(VehicleEntity car, float pt, PoseStack pose) {
        double back = car.backValue.getRenderValue(pt);
        double front = car.frontValue.getRenderValue(pt);
        double left = car.leftValue.getRenderValue(pt);
        double right = car.rightValue.getRenderValue(pt);
        Vector4f d = car.getCarDimensions();
        Vec2 rot = car.getBackWheelRotationPoint();
        pose.m_252880_(0.0f, rot.f_82470_, rot.f_82471_);
        float pitch = (float)MathUtils.cosineFromPoints(new Vec3(front, 0.0, (double)d.w()), new Vec3(back, 0.0, (double)d.w()), new Vec3(back, 0.0, (double)d.y()));
        pitch = Mth.m_14036_((float)pitch, (float)-45.0f, (float)45.0f);
        if (RebornConfig.enableVehicleTilting) {
            pose.m_252781_(Axis.f_252529_.m_252977_(back > front ? -pitch : pitch));
        }
        float roll = (float)MathUtils.cosineFromPoints(new Vec3(right, 0.0, (double)d.z()), new Vec3(left, 0.0, (double)d.z()), new Vec3(left, 0.0, (double)d.x()));
        roll = Mth.m_14036_((float)roll, (float)-45.0f, (float)45.0f);
        if (RebornConfig.enableVehicleTilting) {
            pose.m_252781_(Axis.f_252403_.m_252977_(left > right ? -roll : roll));
        }
        pose.m_252880_(0.0f, -rot.f_82470_, -rot.f_82471_);
        float f = RebornConfig.enableVehicleTilting ? (back > front ? -pitch : pitch) : (car.pitch = 0.0f);
        car.roll = RebornConfig.enableVehicleTilting ? (left > right ? -roll : roll) : 0.0f;
    }

    @Nullable
    public ResourceLocation getTextureLocation(E entity) {
        return this.texture;
    }

    protected static <T extends VehicleEntity> EntityRendererProvider<T> factory(String carName, final Supplier<CarAnimator> sup) {
        return ctx -> new CarRenderer<T>(ctx, carName, (CarAnimator)sup.get()){

            @Override
            protected CarAnimator createCarAnimator() {
                return (CarAnimator)sup.get();
            }
        };
    }

    protected abstract CarAnimator createCarAnimator();
}

