/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.item;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.vit.jurassicreborn.JurassicReborn;
import net.vit.jurassicreborn.client.render.item.StorageDiscBakedModel;
import net.vit.jurassicreborn.common.items.genetics.StorageDiscModelData;

@Mod.EventBusSubscriber(modid="jurassicreborn", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class StorageDiscModelHandler {
    private StorageDiscModelHandler() {
    }

    @SubscribeEvent
    public static void onRegisterAdditional(ModelEvent.RegisterAdditional event) {
        Int2ObjectMap<ResourceLocation> models = StorageDiscModelData.getModels();
        for (Int2ObjectMap.Entry entry : models.int2ObjectEntrySet()) {
            event.register((ResourceLocation)new ModelResourceLocation((ResourceLocation)entry.getValue(), "inventory"));
        }
    }

    @SubscribeEvent
    public static void onModifyBakingResult(ModelEvent.ModifyBakingResult event) {
        StorageDiscModelHandler.injectStorageDiscModel(event.getModels());
    }

    @SubscribeEvent
    public static void onBakingCompleted(ModelEvent.BakingCompleted event) {
        StorageDiscModelHandler.injectStorageDiscModel(event.getModels());
    }

    private static void injectStorageDiscModel(Map<?, BakedModel> models) {
        ResourceLocation storageDiscLoc = new ResourceLocation("jurassicreborn", "storage_disc");
        ModelResourceLocation storageDiscModelLoc = new ModelResourceLocation(storageDiscLoc, "inventory");
        BakedModel baseModel = models.get(storageDiscModelLoc);
        if (baseModel == null || baseModel instanceof StorageDiscBakedModel) {
            baseModel = models.get(storageDiscLoc);
        }
        if (baseModel == null || baseModel instanceof StorageDiscBakedModel) {
            return;
        }
        Int2ObjectMap<ResourceLocation> modelLocations = StorageDiscModelData.getModels();
        Int2ObjectArrayMap bakedVariants = new Int2ObjectArrayMap();
        for (Int2ObjectMap.Entry entry : modelLocations.int2ObjectEntrySet()) {
            ModelResourceLocation loc = new ModelResourceLocation((ResourceLocation)entry.getValue(), "inventory");
            BakedModel variant = models.get(loc);
            if (variant == null) {
                variant = models.get(entry.getValue());
            }
            if (variant == null) continue;
            bakedVariants.put(entry.getIntKey(), (Object)variant);
        }
        StorageDiscBakedModel wrapped = new StorageDiscBakedModel(baseModel, (Int2ObjectMap<BakedModel>)bakedVariants);
        try {
            if (models.containsKey(storageDiscModelLoc)) {
                models.put(storageDiscModelLoc, (BakedModel)wrapped);
            } else {
                models.put(storageDiscLoc, (BakedModel)wrapped);
            }
        }
        catch (UnsupportedOperationException e) {
            JurassicReborn.getLogger().warn("Skipping storage disc model injection because baked model map is immutable ({}).", (Object)models.getClass().getName(), (Object)e);
        }
    }
}

