/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.JurassicReborn;
import net.vit.jurassicreborn.common.blocks.entities.DNABlocks.DNACombinatorHybridizer.DNACombinatorHybridizerBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.DNABlocks.DNACombinatorHybridizer.DNACombinatorHybridizerMenu;
import net.vit.jurassicreborn.common.network.Network;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DNACombinatorHybridizerScreen
extends AbstractContainerScreen<DNACombinatorHybridizerMenu> {
    private static final ResourceLocation hybridizerTexture = JurassicReborn.resource("textures/gui/dna_hybridizer.png");
    private static final ResourceLocation combinatorTexture = JurassicReborn.resource("textures/gui/dna_combinator.png");
    private final Inventory playerInventory;
    private DNACombinatorHybridizerMenu menu;
    private Button switchModeButton;

    public DNACombinatorHybridizerScreen(DNACombinatorHybridizerMenu menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        this.playerInventory = playerInv;
        this.menu = menu;
    }

    @NotNull
    public Component m_96636_() {
        BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(new BlockPos(this.menu.getField(3), this.menu.getField(4), this.menu.getField(5)));
        if (blockEntity instanceof DNACombinatorHybridizerBlockEntity) {
            DNACombinatorHybridizerBlockEntity e = (DNACombinatorHybridizerBlockEntity)blockEntity;
            return e.m_5446_();
        }
        return this.f_96539_;
    }

    public DNACombinatorHybridizerScreen(DNACombinatorHybridizerMenu dnaCombinatorHybridizerMenu, Inventory inventory, Component component, BlockEntity entity) {
        this(dnaCombinatorHybridizerMenu, inventory, component);
    }

    protected void m_7856_() {
        super.m_7856_();
        int xSize = this.f_97735_;
        int ySize = this.f_97736_;
        this.f_97729_ -= 3;
        this.switchModeButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<->"), w -> {
            BlockPos entityPos = new BlockPos(this.menu.getField(3), this.menu.getField(4), this.menu.getField(5));
            boolean mode = !this.menu.getMode();
            this.menu.updateSlots(!mode);
            this.menu.setMode(mode);
            Network.switchHybridizerCombinerMode(mode, entityPos, (ResourceKey<Level>)this.playerInventory.f_35978_.m_9236_().m_46472_());
        }).m_252987_(xSize + 128, ySize + 64, 30, 12).m_253136_());
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int id) {
        return super.m_6375_(pMouseX, pMouseY, id);
    }

    public void m_86412_(@NotNull PoseStack pPoseStack, int mouseX, int mouseY, float pPartialTick) {
        boolean isHybridizer = this.menu.getMode();
        this.menu.updateSlots(!isHybridizer);
        this.f_96539_ = Component.m_237115_((String)(isHybridizer ? "container.dna_hybridizer" : "container.dna_combinator"));
        this.m_7333_(pPoseStack);
        super.m_86412_(pPoseStack, mouseX, mouseY, pPartialTick);
        this.m_7025_(pPoseStack, mouseX, mouseY);
    }

    protected void m_7286_(@NotNull PoseStack pPoseStack, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean isHybridizer = this.menu.getMode();
        this.menu.updateSlots(!isHybridizer);
        RenderSystem.m_157456_((int)0, (ResourceLocation)(isHybridizer ? hybridizerTexture : combinatorTexture));
        int xSize = this.f_97735_;
        int ySize = this.f_97736_;
        int centerX = (this.f_96543_ - xSize) / 2;
        int centerY = (this.f_96544_ - ySize) / 2;
        this.m_93228_(pPoseStack, xSize, ySize, 0, 0, 176, 166);
        int progress = this.getProgress(isHybridizer ? 27 : 24);
        if (isHybridizer) {
            this.m_93228_(pPoseStack, this.f_97735_ + 86, this.f_97736_ + 25, 176, 0, 4, progress);
        } else {
            if (progress >= 2) {
                this.m_93228_(pPoseStack, this.f_97735_ + 93, this.f_97736_ + 31, 176, 1, 8, progress - 1);
            }
            if (progress >= 1) {
                this.m_93228_(pPoseStack, this.f_97735_ + 93, this.f_97736_ + 30, 176, 1, 8, progress == 1 ? 1 : 2);
            }
        }
        this.switchModeButton.m_6303_(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    private int getProgress(int scale) {
        int j = this.menu.getField(0);
        int k = this.menu.getField(1);
        return k != 0 && j != 0 ? j * scale / k : 0;
    }
}

