/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.DNABlocks.DNAExtractor;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.vit.jurassicreborn.JurassicReborn;
import net.vit.jurassicreborn.common.blocks.entities.DNABlocks.DNAExtractor.DNAExtractorMenu;
import net.vit.jurassicreborn.common.blocks.entities.MachineBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.MachineItemStackHandler;
import net.vit.jurassicreborn.common.blocks.entities.ModBlockEntities;
import net.vit.jurassicreborn.common.blocks.entities.grinder.FossilGrinderBlockEntity;
import net.vit.jurassicreborn.common.blocks.inventory.DNAExtractorHandler;
import net.vit.jurassicreborn.common.blocks.inventory.ItemHandlerBlockEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.genetics.DinoDNA;
import net.vit.jurassicreborn.common.genetics.GeneticsHelper;
import net.vit.jurassicreborn.common.genetics.PlantDNA;
import net.vit.jurassicreborn.common.items.Food.DinosaurMeatItem;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.items.genetics.StorageDiscItem;
import net.vit.jurassicreborn.common.network.Network;
import net.vit.jurassicreborn.common.plants.Plant;
import net.vit.jurassicreborn.common.plants.PlantHandler;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DNAExtractorBlockEntity
extends MachineBlockEntity
implements MenuProvider,
ItemHandlerBlockEntity,
GeoBlockEntity {
    public static final int SLOTS = 6;
    public static final int[] INPUTS = new int[]{0, 1};
    public static final int[] OUTPUTS = new int[]{2, 3, 4, 5};
    public static final int PROCESS_TIME = 2000;
    protected final MachineItemStackHandler machineItemStackHandler = new DNAExtractorHandler(6, INPUTS, OUTPUTS);
    public final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            if (pIndex == 0) {
                return DNAExtractorBlockEntity.this.extractionTime;
            }
            return -1;
        }

        public void m_8050_(int pIndex, int pValue) {
            if (pIndex == 0) {
                DNAExtractorBlockEntity.this.extractionTime = pValue;
            }
        }

        public int m_6499_() {
            return 1;
        }
    };
    private int extractionTime = 0;
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.dna_extractor.idle");
    private final AnimatableInstanceCache animationCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    @Override
    public IItemHandlerModifiable getItemHandler() {
        return this.machineItemStackHandler;
    }

    public DNAExtractorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.DNA_EXTRACTOR_BLOCK_ENTITY.get(), pPos, pBlockState);
        this.machineItemStackHandler.setChangeListener(() -> {
            this.m_6596_();
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        });
    }

    @Override
    @NotNull
    protected Component getDefaultName() {
        return Component.m_237115_((String)"block.jurassicreborn.dna_extractor");
    }

    public Component m_5446_() {
        return super.m_5446_();
    }

    @NotNull
    public AbstractContainerMenu m_7208_(int pContainerId, @NotNull Inventory pInventory, Player player) {
        return new DNAExtractorMenu(pContainerId, this.machineItemStackHandler, this.data, pInventory);
    }

    @Override
    public boolean canProcess(ItemStack ... inputs) {
        return !this.getItem(0).m_41619_() && !this.getItem(1).m_41619_() && this.hasSpace();
    }

    public boolean hasSpace() {
        for (int i : OUTPUTS) {
            if (!this.getItem(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, DNAExtractorBlockEntity pBlockEntity) {
        if (pLevel.f_46443_) {
            return;
        }
        if (!pBlockEntity.canProcess(pBlockEntity.machineItemStackHandler.getStackInSlot(0))) {
            pBlockEntity.extractionTime = 0;
            return;
        }
        ++pBlockEntity.extractionTime;
        if (pBlockEntity.extractionTime >= 2000) {
            pBlockEntity.processItem(pBlockEntity.machineItemStackHandler.getStackInSlot(0));
            pBlockEntity.extractionTime = 0;
        }
    }

    private static DinoDNA readDNAFromItem(ItemStack src, Dinosaur fallbackDino, RandomSource rand) {
        CompoundTag in = src.m_41783_();
        if (in != null) {
            DinoDNA existing = DinoDNA.readFromNBT(in);
            if (existing != null) {
                return existing;
            }
            int q = in.m_128441_("DNAQuality") ? in.m_128451_("DNAQuality") : 100;
            String g = in.m_128441_("Genetics") ? in.m_128461_("Genetics") : GeneticsHelper.randomGenetics(rand);
            return new DinoDNA(fallbackDino, q, g);
        }
        return new DinoDNA(fallbackDino, 100, GeneticsHelper.randomGenetics(rand));
    }

    @Override
    @NotNull
    public List<ItemStack> processItem(ItemStack ... input) {
        RandomSource rand = Objects.requireNonNull(this.f_58857_).m_213780_();
        ItemStack src = input[0];
        Item item = src.m_41720_();
        ItemStack disc = ItemStack.f_41583_;
        if (item == ModItems.MOSQUITO_AMBER.get()) {
            List<Dinosaur> possible = DinosaurHandler.getDinosaursFromAmber();
            Dinosaur dino = possible.get(rand.m_188503_(possible.size()));
            disc = ((StorageDiscItem)ModItems.STORAGE_DISC.get()).m_7968_();
            new DinoDNA(dino, 50 + rand.m_188503_(50), GeneticsHelper.randomGenetics(rand)).writeToNBT(disc.m_41784_());
            StorageDiscItem.applyCustomModelData(disc);
        } else if (item == ModItems.SEA_LAMPREY.get()) {
            List<Dinosaur> possible = DinosaurHandler.getMarineCreatures();
            Dinosaur dino = possible.get(rand.m_188503_(possible.size()));
            disc = ((StorageDiscItem)ModItems.STORAGE_DISC.get()).m_7968_();
            new DinoDNA(dino, 50 + rand.m_188503_(50), GeneticsHelper.randomGenetics(rand)).writeToNBT(disc.m_41784_());
            StorageDiscItem.applyCustomModelData(disc);
        } else if (item == ModItems.FROZEN_LEECH_ITEM.get()) {
            List<Dinosaur> possible = DinosaurHandler.getMammalCreatures();
            Dinosaur dino = possible.get(rand.m_188503_(possible.size()));
            disc = ((StorageDiscItem)ModItems.STORAGE_DISC.get()).m_7968_();
            new DinoDNA(dino, 50 + rand.m_188503_(50), GeneticsHelper.randomGenetics(rand)).writeToNBT(disc.m_41784_());
            StorageDiscItem.applyCustomModelData(disc);
        } else if (item == ModItems.APHID_AMBER.get()) {
            List<Plant> possiblePlants = PlantHandler.getPrehistoricPlantsAndTrees();
            Plant plant = possiblePlants.get(rand.m_188503_(possiblePlants.size()));
            disc = ((StorageDiscItem)ModItems.STORAGE_DISC.get()).m_7968_();
            new PlantDNA(JurassicReborn.resource(plant.getName().toLowerCase(Locale.ROOT).replace(" ", "_")), 50 + rand.m_188503_(50)).writeToNBT(disc.m_41784_());
            StorageDiscItem.applyCustomModelData(disc);
        } else if (item instanceof DinosaurMeatItem) {
            DinosaurMeatItem meat = (DinosaurMeatItem)item;
            ItemStack discOut = ((StorageDiscItem)ModItems.STORAGE_DISC.get()).m_7968_();
            FossilGrinderBlockEntity.copyDNA(input[0], discOut);
            disc = discOut;
            StorageDiscItem.applyCustomModelData(disc);
        }
        if (!disc.m_41619_()) {
            src.m_41774_(1);
            this.machineItemStackHandler.setStackInSlot(0, src);
            ItemStack inputDisc = this.getItem(1);
            inputDisc.m_41774_(1);
            this.setItem(1, inputDisc);
            this.setItem(this.getOpenSlot(), disc);
        }
        return List.of(ItemStack.f_41583_);
    }

    public int getOpenSlot() {
        for (int i = 2; i <= 6; ++i) {
            if (!this.getItem(i).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle", 0, this::idleController)});
    }

    private PlayState idleController(AnimationState<DNAExtractorBlockEntity> state) {
        return state.setAndContinue(IDLE);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationCache;
    }

    @Override
    public Tag getMachineData() {
        CompoundTag data = new CompoundTag();
        data.m_128405_("ExtractionTime", this.extractionTime);
        return data;
    }

    @Override
    public void readMachineData(Tag tag) {
        CompoundTag machineData = (CompoundTag)tag;
        this.extractionTime = machineData.m_128451_("ExtractionTime");
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        Network.ENTITIES.remove(this);
    }
}

