/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.common.blocks.entities.ActionFigureBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.ModBlockEntities;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;

public class HologramBlockEntity
extends ActionFigureBlockEntity {
    public static final int ROTATION_STEP_DEGREES = 45;
    public static final String TAG_DINO_INDEX = "DinoIndex";
    public static final String TAG_POSE_INDEX = "PoseIndex";
    public static final String TAG_ROTATING = "Rotating";
    public static final String TAG_ROTATION = "Rotation";
    private int dinoIndex = 0;
    private int poseIndex = 0;
    private boolean rotating = true;
    private int cachedRotation = 0;

    public HologramBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ActionFigureBlockEntity>)((BlockEntityType)ModBlockEntities.HOLOGRAM_BLOCK_ENTITY.get()), pos, state);
    }

    public static int snapRotation(int rotation) {
        int snapped = (int)Math.round((double)rotation / 45.0) * 45;
        return Math.floorMod(snapped, 360);
    }

    private void markForSaving() {
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_46745_(this.f_58858_).m_8092_(true);
        }
    }

    @Override
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Override
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.m_142466_(tag);
            if (this.f_58857_ != null && this.f_58857_.f_46443_) {
                this.checkAndLoadEntity();
            }
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (this.f_58857_ != null) {
            System.out.println("Loading Hologram NBT - has dinoIndex: " + tag.m_128441_(TAG_DINO_INDEX) + ", has pose: " + tag.m_128441_(TAG_POSE_INDEX) + ", has rotating: " + tag.m_128441_(TAG_ROTATING) + ", has rotation: " + tag.m_128441_(TAG_ROTATION));
        }
        DinosaurHandler.doDinosInit();
        int loadedIndex = this.dinoIndex;
        if (tag.m_128425_(TAG_DINO_INDEX, 3)) {
            loadedIndex = tag.m_128451_(TAG_DINO_INDEX);
        } else if (tag.m_128425_("Dinosaur", 8)) {
            Dinosaur saved = Dinosaur.getDinosaurByName(tag.m_128461_("Dinosaur"));
            loadedIndex = DinosaurHandler.getId(saved);
        }
        int poseCount = Math.max(EntityAnimation.values().length, 1);
        int loadedPose = tag.m_128425_(TAG_POSE_INDEX, 3) ? tag.m_128451_(TAG_POSE_INDEX) : this.poseIndex;
        boolean loadedRotating = !tag.m_128441_(TAG_ROTATING) || tag.m_128471_(TAG_ROTATING);
        int storedRot = tag.m_128425_(TAG_ROTATION, 3) ? tag.m_128451_(TAG_ROTATION) : this.cachedRotation;
        int dinoCount = DinosaurHandler.count();
        if (dinoCount <= 0) {
            int normalizedRotation;
            this.dinoIndex = loadedIndex;
            this.poseIndex = Math.floorMod(loadedPose, poseCount);
            this.rotating = loadedRotating;
            this.cachedRotation = normalizedRotation = loadedRotating ? Math.floorMod(storedRot, 360) : HologramBlockEntity.snapRotation(storedRot);
            this.setRotationSilently(normalizedRotation);
            this.markForSaving();
            return;
        }
        this.applySettings(Math.floorMod(loadedIndex, Math.max(dinoCount, 1)), Math.floorMod(loadedPose, Math.max(poseCount, 1)), loadedRotating, storedRot, false);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_(TAG_DINO_INDEX, this.dinoIndex);
        tag.m_128405_(TAG_POSE_INDEX, this.poseIndex);
        tag.m_128379_(TAG_ROTATING, this.rotating);
        tag.m_128405_(TAG_ROTATION, this.getRot());
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            System.out.println("Saving Hologram NBT: dino=" + this.dinoIndex + ", pose=" + this.poseIndex + ", rotating=" + this.rotating + ", rotation=" + this.getRot());
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        DinosaurHandler.doDinosInit();
        Dinosaur dino = DinosaurHandler.getById(this.dinoIndex);
        if (dino != null && dino != Dinosaur.EMPTY) {
            super.setDinosaur(dino, true, false, false);
        }
        if (!this.rotating) {
            this.setRotationSilently(this.cachedRotation);
        }
        this.applyPose();
    }

    public void clientTick(Level level, BlockPos pos, BlockState state) {
        if (this.rotating) {
            this.setRotationSilently((this.getRot() + 2) % 360);
        }
        this.applyPose();
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
    }

    public void setDinosaurById(int id) {
        DinosaurHandler.doDinosInit();
        int count = Math.max(DinosaurHandler.count(), 1);
        this.dinoIndex = Math.floorMod(id, count);
        Dinosaur dino = DinosaurHandler.getById(this.dinoIndex);
        this.setDinosaur(dino, true, false, false);
        this.applyPose();
        this.markForSaving();
    }

    @Override
    public void setDinosaur(Dinosaur dino, boolean gender, boolean isSkeleton, boolean isFossile) {
        super.setDinosaur(dino, gender, isSkeleton, isFossile);
        this.dinoIndex = DinosaurHandler.getId(dino);
    }

    public void setPoseIndex(int poseIndex) {
        int count = EntityAnimation.values().length;
        this.poseIndex = Math.floorMod(poseIndex, count);
        this.applyPose();
        this.markForSaving();
    }

    public void setRotating(boolean rotating) {
        boolean wasRotating = this.rotating;
        this.rotating = rotating;
        if (wasRotating && !rotating) {
            int snapped = HologramBlockEntity.snapRotation(this.getRot());
            this.setRotationSilently(snapped);
            this.cachedRotation = snapped;
        }
        this.markForSaving();
    }

    @Override
    public void setRot(int rotation) {
        int finalRotation;
        this.cachedRotation = finalRotation = this.rotating ? Math.floorMod(rotation, 360) : HologramBlockEntity.snapRotation(rotation);
        this.setRotationSilently(finalRotation);
        this.markForSaving();
    }

    public int getDinoIndex() {
        return this.dinoIndex;
    }

    public int getPoseIndex() {
        return this.poseIndex;
    }

    public boolean isRotating() {
        return this.rotating;
    }

    public EntityAnimation getPoseAnimation() {
        EntityAnimation[] values = EntityAnimation.values();
        return values[Math.floorMod(this.poseIndex, values.length)];
    }

    private void applyPose() {
        DinosaurEntity entity;
        if (this.f_58857_ != null && (entity = this.getEntity()) != null) {
            entity.setAnimation(this.getPoseAnimation().get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applySettings(int dinoIndex, int poseIndex, boolean rotating, int rotation, boolean sync) {
        DinosaurHandler.doDinosInit();
        int dinoCount = Math.max(DinosaurHandler.count(), 1);
        int normalizedDino = Math.floorMod(dinoIndex, dinoCount);
        int poseCount = Math.max(EntityAnimation.values().length, 1);
        int normalizedPose = Math.floorMod(poseIndex, poseCount);
        int normalizedRotation = rotating ? Math.floorMod(rotation, 360) : HologramBlockEntity.snapRotation(rotation);
        boolean previousSuppressed = this.suppressUpdates;
        this.suppressUpdates = true;
        try {
            this.dinoIndex = normalizedDino;
            this.poseIndex = normalizedPose;
            this.rotating = rotating;
            this.cachedRotation = normalizedRotation;
            this.setRotationSilently(normalizedRotation);
            Dinosaur dino = DinosaurHandler.getById(normalizedDino);
            if (dino != null) {
                this.setDinosaur(dino, true, false, false);
            }
            this.applyPose();
        }
        finally {
            this.suppressUpdates = previousSuppressed;
        }
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_46745_(this.f_58858_).m_8092_(true);
        }
        if (sync && this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
        System.out.println("Applied settings: dino=" + this.dinoIndex + ", pose=" + this.poseIndex + ", rotating=" + this.rotating + ", rotation=" + this.cachedRotation + ", isClient=" + (this.f_58857_ != null && this.f_58857_.f_46443_) + ", sync=" + sync);
    }

    public void applySettingsFromTag(CompoundTag tag, boolean sync) {
        int dinoIndex = tag.m_128425_(TAG_DINO_INDEX, 3) ? tag.m_128451_(TAG_DINO_INDEX) : this.dinoIndex;
        int poseIndex = tag.m_128425_(TAG_POSE_INDEX, 3) ? tag.m_128451_(TAG_POSE_INDEX) : this.poseIndex;
        boolean rotating = !tag.m_128441_(TAG_ROTATING) || tag.m_128471_(TAG_ROTATING);
        int rotation = tag.m_128425_(TAG_ROTATION, 3) ? tag.m_128451_(TAG_ROTATION) : this.cachedRotation;
        this.applySettings(dinoIndex, poseIndex, rotating, rotation, sync);
    }
}

